//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_iostream.cpp
 * @brief		iostreamT|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_iris_iostream_CPP_

//======================================================================
// include
#include "iris_iostream.h"
#include "iris_using.h"
#include "wchar.h"

#ifndef _IRIS_NOT_SUPPORT_IOSTREAM
//======================================================================
// define
// ֐`}N
#define IOSTREAM_FUNC_IMPL_BASE(strm, op, type, impl, text)					\
	std::strm&	operator op (std::strm& ios, const type& val)	{ impl(text) }

#define IOSTREAM_FUNC_IMPL_MBS(strm, op, type, impl)						\
	IOSTREAM_FUNC_IMPL_BASE(strm, op, type, impl, IRIS_TEXTA)

#if	IRIS_WCS
#  define IOSTREAM_FUNC_IMPL_WCS(strm, op, type, impl)						\
	IOSTREAM_FUNC_IMPL_BASE(w##strm, op, type, impl, IRIS_TEXTW)
#else
#  define IOSTREAM_FUNC_IMPL_WCS(strm, op, type, impl)
#endif

#define IOSTREAM_FUNC_IMPL(strm, op, type, impl)							\
	IOSTREAM_FUNC_IMPL_WCS(strm, op, type, impl)							\
	IOSTREAM_FUNC_IMPL_MBS(strm, op, type, impl)

//======================================================================
// function
// IrisSRect
#define OS_SRECT_IMPL(_t)	return ios << val.left << _t(", ") << val.top		\
								<< _t(", ") << val.right << _t(", ") << val.bottom;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisSRect, OS_SRECT_IMPL)
// IrisFRect
#define OS_FRECT_IMPL(_t)	return ios << val.left << _t(", ") << val.top		\
								<< _t(", ") << val.right << _t(", ") << val.bottom;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFRect, OS_FRECT_IMPL)
// IrisXFRect
#define OS_XFRECT_IMPL(_t)							\
	IrisXF32 left	= XF_XF32_TO_F32(val.left);		\
	IrisXF32 top	= XF_XF32_TO_F32(val.top);		\
	IrisXF32 right	= XF_XF32_TO_F32(val.right);	\
	IrisXF32 bottom	= XF_XF32_TO_F32(val.bottom);	\
	return ios << left << _t(", ") << top			\
	<< _t(", ") << right << _t(", ") << bottom;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFRect, OS_XFRECT_IMPL)
// IrisIRect
#define OS_IRECT_IMPL(_t)	return ios << val.left << _t(", ") << val.top		\
								<< _t(", ") << val.right << _t(", ") << val.bottom;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisIRect, OS_IRECT_IMPL)
// IrisRect
#define OS_RECT_IMPL(_t)	return ios << val.fv;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisRect, OS_RECT_IMPL)

// vec2
// IrisSVec2
#define OS_SVEC2_IMPL(_t)	return ios << val.x << _t(", ") << val.y;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisSVec2, OS_SVEC2_IMPL)
// IrisFVec2
#define OS_FVEC2_IMPL(_t)	return ios << val.x << _t(", ") << val.y;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFVec2, OS_FVEC2_IMPL)
// IrisXFVec2
#define OS_XFVEC2_IMPL(_t)				\
	IrisXF32 x = XF_XF32_TO_F32(val.x);	\
	IrisXF32 y = XF_XF32_TO_F32(val.y);	\
	return ios << x << ", " << y;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFVec2, OS_XFVEC2_IMPL)
// IrisIVec2
#define OS_IVEC2_IMPL(_t)	return ios << val.x << _t(", ") << val.y;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisIVec2, OS_IVEC2_IMPL)
// IrisVec2
#define OS_VEC2_IMPL(_t)	return ios << val.fv;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisVec2, OS_VEC2_IMPL)

// vec3
// IrisSVec3
#define OS_SVEC3_IMPL(_t)	return ios << val.x << _t(", ") << val.y << _t(", ") << val.z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisSVec3, OS_SVEC3_IMPL)
// IrisFVec3
#define OS_FVEC3_IMPL(_t)	return ios << val.x << _t(", ") << val.y << _t(", ") << val.z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFVec3, OS_FVEC3_IMPL)
// IrisXFVec3
#define OS_XFVEC3_IMPL(_t)				\
	IrisXF32 x = XF_XF32_TO_F32(val.x);	\
	IrisXF32 y = XF_XF32_TO_F32(val.y);	\
	IrisXF32 z = XF_XF32_TO_F32(val.z);	\
	return ios << x << _t(", ") << y << _t(", ") << z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFVec3, OS_XFVEC3_IMPL)
// IrisIVec3
#define OS_IVEC3_IMPL(_t)	return ios << val.x << _t(", ") << val.y << _t(", ") << val.z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisIVec3, OS_IVEC3_IMPL)
// IrisVec3
#define OS_VEC3_IMPL(_t)	return ios << val.fv;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisVec3, OS_VEC3_IMPL)

// vec4
// IrisSVec4
#define OS_SVEC4_IMPL(_t)	return ios << val.x << _t(", ") << val.y << _t(", ") << val.z << _t(", ") << val.w;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisSVec4, OS_SVEC4_IMPL)
// IrisFVec4
#define OS_FVEC4_IMPL(_t)	return ios << val.x << _t(", ") << val.y << _t(", ") << val.z << _t(", ") << val.w;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFVec4, OS_FVEC4_IMPL)
// IrisXFVec4
#define OS_XFVEC4_IMPL(_t)				\
	IrisXF32 x = XF_XF32_TO_F32(val.x);	\
	IrisXF32 y = XF_XF32_TO_F32(val.y);	\
	IrisXF32 z = XF_XF32_TO_F32(val.z);	\
	IrisXF32 w = XF_XF32_TO_F32(val.w);	\
	return ios << x << _t(", ") << y << _t(", ") << z << _t(", ") << w;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFVec4, OS_XFVEC4_IMPL)
// IrisIVec4
#define OS_IVEC4_IMPL(_t)	return ios << val.x << _t(", ") << val.y << _t(", ") << val.z << _t(", ") << val.w;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisIVec4, OS_IVEC4_IMPL)
// IrisVec4
#define OS_VEC4_IMPL(_t)	return ios << val.fv;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisVec4, OS_VEC4_IMPL)


// IrisFMtx22
#define OS_XMTX22_IMPL(_t)	return ios << val.x << std::endl << val.y;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFMtx22, OS_XMTX22_IMPL)
// IrisXFMtx22
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFMtx22, OS_XMTX22_IMPL)
// IrisIMtx22
IOSTREAM_FUNC_IMPL(ostream, <<, IrisIMtx22, OS_XMTX22_IMPL)
// IrisMtx22
#define OS_MTX22_IMPL(_t)	return ios << val.fm;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisMtx22, OS_MTX22_IMPL)

// IrisFMtx33
#define OS_XMTX33_IMPL(_t)	return ios << val.x << std::endl << val.y << std::endl << val.z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFMtx33, OS_XMTX33_IMPL)
// IrisXFMtx33
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFMtx33, OS_XMTX33_IMPL)
// IrisIMtx33
IOSTREAM_FUNC_IMPL(ostream, <<, IrisIMtx33, OS_XMTX33_IMPL)
// IrisMtx33
#define OS_MTX33_IMPL(_t)	return ios << val.fm;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisMtx33, OS_MTX33_IMPL)

// IrisFMtx43
#define OS_XMTX43_IMPL(_t)	return ios << val.x << std::endl << val.y << std::endl << val.z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFMtx43, OS_XMTX43_IMPL)
// IrisXFMtx43
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFMtx43, OS_XMTX43_IMPL)
// IrisIMtx43
IOSTREAM_FUNC_IMPL(ostream, <<, IrisIMtx43, OS_XMTX43_IMPL)
// IrisMtx43
#define OS_MTX43_IMPL(_t)	return ios << val.fm;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisMtx43, OS_MTX43_IMPL)

// IrisFMtx44
#define OS_XMTX44_IMPL(_t)	return ios << val.x << std::endl << val.y << std::endl << val.z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFMtx44, OS_XMTX44_IMPL)
// IrisXFMtx44
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFMtx44, OS_XMTX44_IMPL)
// IrisIMtx44
IOSTREAM_FUNC_IMPL(ostream, <<, IrisIMtx44, OS_XMTX44_IMPL)
// IrisMtx44
#define OS_MTX44_IMPL(_t)	return ios << val.fm;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisMtx44, OS_MTX44_IMPL)

// IrisFPlane
#define OS_FPLANE_IMPL(_t)	return ios << val.a << _t(", ") << val.b << _t(", ") << val.c << _t(", ") << val.d;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFPlane, OS_FPLANE_IMPL)
// IrisXFComplex
#define OS_XFPLANE_IMPL(_t)				\
	IrisXF32 a = XF_XF32_TO_F32(val.a);	\
	IrisXF32 b = XF_XF32_TO_F32(val.b);	\
	IrisXF32 c = XF_XF32_TO_F32(val.c);	\
	IrisXF32 d = XF_XF32_TO_F32(val.d);	\
	return ios << a << _t(", ") << b << _t(", ") << c << _t(", ") << d;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFPlane, OS_XFPLANE_IMPL)

// IrisFColor
#define OS_FCOLOR_IMPL(_t)							\
	return ios << _t("R:") << val.r << std::endl	\
	<< _t("G: ") << val.g << std::endl				\
	<< _t("B: ") << val.b << std::endl				\
	<< _t("A: ") << val.a;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFColor, OS_FCOLOR_IMPL)
// IrisXFColor
#define OS_XFCOLOR_IMPL(_t)						\
	IrisXF32 r = XF_XF32_TO_F32(val.r);			\
	IrisXF32 g = XF_XF32_TO_F32(val.g);			\
	IrisXF32 b = XF_XF32_TO_F32(val.b);			\
	IrisXF32 a = XF_XF32_TO_F32(val.a);			\
	return ios << _t("R:") << r << std::endl	\
	<< _t("G: ") << g << std::endl				\
	<< _t("B: ") << b << std::endl				\
	<< _t("A: ") << a;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFColor, OS_XFCOLOR_IMPL)

// IrisFCMY
#define OS_FCMY_IMPL(_t)							\
	return ios << _t("C:") << val.c << std::endl	\
	<< _t("M: ") << val.m << std::endl				\
	<< _t("Y: ") << val.y;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFCMY, OS_FCMY_IMPL)
// IrisXFCMY
#define OS_XFCMY_IMPL(_t)						\
	IrisXF32 c = XF_XF32_TO_F32(val.c);			\
	IrisXF32 m = XF_XF32_TO_F32(val.m);			\
	IrisXF32 y = XF_XF32_TO_F32(val.y);			\
	return ios << _t("C:") << c << std::endl	\
	<< _t("M: ") << m << std::endl				\
	<< _t("Y: ") << y;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFCMY, OS_XFCMY_IMPL)

// IrisFCMYK
#define OS_FCMYK_IMPL(_t)							\
	return ios << _t("C:") << val.c << std::endl	\
	<< _t("M: ") << val.m << std::endl				\
	<< _t("Y: ") << val.y << std::endl				\
	<< _t("K: ") << val.k;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFCMYK, OS_FCMYK_IMPL)
// IrisXFCMY
#define OS_XFCMYK_IMPL(_t)						\
	IrisXF32 c = XF_XF32_TO_F32(val.c);			\
	IrisXF32 m = XF_XF32_TO_F32(val.m);			\
	IrisXF32 y = XF_XF32_TO_F32(val.y);			\
	IrisXF32 k = XF_XF32_TO_F32(val.k);			\
	return ios << _t("C:") << c << std::endl	\
	<< _t("M: ") << m << std::endl				\
	<< _t("Y: ") << y << std::endl				\
	<< _t("K: ") << k;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFCMYK, OS_XFCMYK_IMPL)

// IrisFHSV
#define OS_FHSV_IMPL(_t)							\
	return ios << _t("H:") << val.h << std::endl	\
	<< _t("S: ") << val.s << std::endl				\
	<< _t("V: ") << val.v;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFHSV, OS_FHSV_IMPL)
// IrisXFCMY
#define OS_XFHSV_IMPL(_t)						\
	IrisXF32 h = XF_XF32_TO_F32(val.h);			\
	IrisXF32 s = XF_XF32_TO_F32(val.s);			\
	IrisXF32 v = XF_XF32_TO_F32(val.v);			\
	return ios << _t("H:") << h << std::endl	\
	<< _t("S: ") << s << std::endl				\
	<< _t("V: ") << v;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFHSV, OS_XFHSV_IMPL)

// IrisFComplex
#define OS_FCOMPLEX_IMPL(_t)	return ios << val.re << _t("+") << val.im << _t("i");
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFComplex, OS_FCOMPLEX_IMPL)
// IrisXFComplex
#define OS_XFCOMPLEX_IMPL(_t)				\
	IrisXF32 re = XF_XF32_TO_F32(val.re);	\
	IrisXF32 im = XF_XF32_TO_F32(val.im);	\
	return ios << re << _t("+") << im << _t("i");
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFComplex, OS_XFCOMPLEX_IMPL)

// IrisFInt
#define OS_FINT_IMPL(_t)	return ios << val.fv;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisFInt, OS_FINT_IMPL)
// IrisXFInt
#define OS_XFINT_IMPL(_t)					\
	IrisXF32 fv = XF_XF32_TO_F32(val.fv);	\
	return ios << fv;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFInt, OS_XFINT_IMPL)

// IrisVaugeBool
#define OS_VAUGEBOOL_IMPL(_t)				\
	return ios << val.val;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisVaugeBool, OS_VAUGEBOOL_IMPL)

// nullptr
#ifdef _IRIS_HAS_NULLPTR_T
#define OS_NULLPTR_IMPL(_t)	IRIS_UNUSED_VARIABLE(val); return ios << _t("nullptr");
IOSTREAM_FUNC_IMPL(ostream, <<, nullptr_t, OS_NULLPTR_IMPL)
#endif

#ifdef _IRIS_SUPPORT_SAFE_ISTREAM
namespace iris
{

//======================================================================
// class

/**********************************************************************//**
 *
 * istream̎擾
 * 
 ----------------------------------------------------------------------
 * @return	istream
*//***********************************************************************/
std::istream& safe_baisc_istream<char>::_in(void)
{
	return std::cin;
}

/**********************************************************************//**
 *
 * istream̎擾
 * 
 ----------------------------------------------------------------------
 * @return	wistream
*//***********************************************************************/
std::wistream& safe_baisc_istream<wchar_t>::_in(void)
{
	return std::wcin;
}

/**********************************************************************//**
 *
 * istream̎擾
 * 
 ----------------------------------------------------------------------
 * @return	istream
*//***********************************************************************/
std::istream& safe_baisc_istream<char>::_in(void) const
{
	return std::cin;
}

/**********************************************************************//**
 *
 * istream̎擾
 * 
 ----------------------------------------------------------------------
 * @return	wistream
*//***********************************************************************/
std::wistream& safe_baisc_istream<wchar_t>::_in(void) const
{
	return std::wcin;
}

/**********************************************************************//**
 *
 * Rs[
 * 
 ----------------------------------------------------------------------
 * @param [in]	dst		= o̓obt@
 * @param [in]	size	= o̓obt@TCY
 * @param [in]	src		= ̓obt@
*//***********************************************************************/
void safe_baisc_istream<char>::_strcpy(char* dst, size_t size, const char* src)
{
	strcpy_s(dst, size, src);
}

/**********************************************************************//**
 *
 * Rs[
 * 
 ----------------------------------------------------------------------
 * @param [in]	dst		= o̓obt@
 * @param [in]	size	= o̓obt@TCY
 * @param [in]	src		= ̓obt@
*//***********************************************************************/
void safe_baisc_istream<wchar_t>::_strcpy(wchar_t* dst, size_t size, const wchar_t* src)
{
	wcscpy_s(dst, size, src);
}

// ^̎̉
template class safe_baisc_istream<char>;
template class safe_baisc_istream<wchar_t>;

}	// end of namespace iris

//======================================================================
// variable
namespace std
{

::iris::safe_istream	safe_cin;	// Sistream(char)ϐ
::iris::safe_wistream	safe_wcin;	// Sistream(wchar_t)ϐ

}	// end of namespace std

#endif

#endif	// #ifndef _IRIS_NOT_SUPPORT_IOSTREAM


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "unit/UnitCore.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(Ciris_iostreamUnitTest, iris_iostreamUnitTest)
{
#ifndef _IRIS_NOT_SUPPORT_IOSTREAM
	{
		IrisSVec2	v2 = {1, 1};
		IrisXFVec3	v3 = {XF32_CONST(20.2f), XF32_CONST(-10.6f), XF32_CONST(0.1f)};
		IrisIVec4	v4 = {0, -1, 1, 1};
		IrisXFComplex cmpx = {XF32_CONST(10.5f), XF32_CONST(1.0f)};

#ifdef UNICODE
		std::wcout << v2	<< std::endl;
		std::wcout << v3	<< std::endl;
		std::wcout << v4	<< std::endl;
		std::wcout << cmpx	<< std::endl;
#else
		std::cout << v2		<< std::endl;
		std::cout << v3		<< std::endl;
		std::cout << v4		<< std::endl;
		std::cout << cmpx	<< std::endl;
#endif
	}

#ifdef _IRIS_SUPPORT_SAFE_ISTREAM
	{
		char str[256];
		int a;
		int b[2];

		std::cout << "" << std::endl;
		std::safe_cin >> str;
		std::cout << str << std::endl;

		std::cout << "10i" << std::endl;
		std::safe_cin >> std::dec >> a;
		std::cout << std::dec << a << std::endl;
		if( std::safe_cin.fail() ) printf("lȊO͂܂B\n");

		std::cout << "16i" << std::endl;
		std::safe_cin >> std::hex >> a;
		std::cout << std::hex << a << std::endl;
		if( std::safe_cin.fail() ) printf("lȊO͂܂B\n");

		IrisFInt fi;
		std::cout << "" << std::endl;
		std::safe_cin >> fi.fv;
		std::cout << std::hex << fi.iv << std::endl;

		std::cout << "10i2" << std::endl;
		std::safe_cin >> std::dec >> b;
		std::cout << std::dec << b[0] << "," << b[1] << std::endl;
		if( std::safe_cin.fail() ) printf("lȊO͂܂B\n");
	}
#endif

#endif
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
