//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_inttypes.h
 * @brief		inttypesΉt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_inttypes_H_
#define INCG_IRIS_iris_inttypes_H_

//======================================================================
// include
#include "iris_stdint.h"

#if	!defined(_INTTYPES_H)

#if		defined(_IRIS_HAS_C99_H)
#  include <inttypes.h>
#  if defined(__cplusplus)
#    if		defined(__STDC_CONSTANT_MACROS) && defined(IRIS_CYGWIN)
#      undef	INTMAX_C
#      undef	UINTMAX_C
#      define	INTMAX_C(c)		c##LL
#      define	UINTMAX_C(c)	c##ULL
#    endif
#  endif
#else
#  if !defined(__cplusplus)
#    define __STDC_LIMIT_MACROS
#    define __STDC_FORMAT_MACROS
#  endif
#  if	defined(__STDC_LIMIT_MACROS)
#    if	(UCHAR_MAX == 0xFF)		// 8
#      define INT8_MIN			SCHAR_MIN
#      define INT8_MAX			SCHAR_MAX
#      define INT_LEAST8_MIN		SCHAR_MIN
#      define INT_LEAST8_MAX		SCHAR_MAX
#      define INT_FAST8_MIN		SCHAR_MIN
#      define INT_FAST8_MAX		SCHAR_MAX
#      define UINT8_MAX			UCHAR_MAX
#      define UINT_LEAST8_MAX		UCHAR_MAX
#      define UINT_FAST8_MAX		UCHAR_MAX
#    else
#      error iris not support
#    endif	// 8
#    if	(USHRT_MAX == 0xFFFF)	// 16
#      define INT16_MIN			SHRT_MIN
#      define INT16_MAX			SHRT_MAX
#      define INT_LEAST16_MIN		SHRT_MIN
#      define INT_LEAST16_MAX		SHRT_MAX
#      define INT_FAST16_MIN		SHRT_MIN
#      define INT_FAST16_MAX		SHRT_MAX
#      define UINT16_MAX			USHRT_MAX
#      define UINT_LEAST16_MAX	USHRT_MAX
#      define UINT_FAST16_MAX		USHRT_MAX
#    else
#      error iris not support
#    endif	// 16
#    if	(ULONG_MAX == 0xFFFFFFFF)	// 32
#      define INT32_MIN			LONG_MIN
#      define INT32_MAX			LONG_MAX
#      define INT_LEAST32_MIN		LONG_MIN
#      define INT_LEAST32_MAX		LONG_MAX
#      define INT_FAST32_MIN		LONG_MIN
#      define INT_FAST32_MAX		LONG_MAX
#      define UINT32_MAX			ULONG_MAX
#      define UINT_LEAST32_MAX	ULONG_MAX
#      define UINT_FAST32_MAX		ULONG_MAX
#    elif	(UINT_MAX = 0xFFFFFFFF)
#      define INT32_MIN			INT_MIN
#      define INT32_MAX			INT_MAX
#      define INT_LEAST32_MIN		INT_MIN
#      define INT_LEAST32_MAX		INT_MAX
#      define INT_FAST32_MIN		INT_MIN
#      define INT_FAST32_MAX		INT_MAX
#      define UINT32_MAX			UINT_MAX
#      define UINT_LEAST32_MAX	UINT_MAX
#      define UINT_FAST32_MAX		UINT_MAX
#    else
#      error iris not support
#    endif	// 32
#    if	!defined(_IRIS_NOT_SUPPORT_LLONG) && (ULLONG_MAX == 18446744073709551615ULL)	// 64
#      if		!defined(_IRIS_SUPPORT_INT128)
#        define INTMAX_MIN			LLONG_MIN
#        define INTMAX_MAX			LLONG_MAX
#        define UINTMAX_MAX			ULLONG_MAX
#      endif
#      define INT64_MIN				LLONG_MIN
#      define INT64_MAX				LLONG_MAX
#      define INT_LEAST64_MIN			LLONG_MIN
#      define INT_LEAST64_MAX			LLONG_MAX
#      define INT_FAST64_MIN			LLONG_MIN
#      define INT_FAST64_MAX			LLONG_MAX
#      define UINT64_MAX				ULLONG_MAX
#      define UINT_LEAST64_MAX		ULLONG_MAX
#      define UINT_FAST64_MAX			ULLONG_MAX
#    elif	(ULONG_MAX != 0xFFFFFFFF)
#      if	(ULONG_MAX == 18446744073709551615)
#        if	!defined(_IRIS_SUPPORT_INT128)
#          define INTMAX_MIN			LONG_MIN
#          define INTMAX_MAX			LONG_MAX
#          define UINTMAX_MAX			ULONG_MAX
#        endif
#        define INT64_MIN				LONG_MIN
#        define INT64_MAX				LONG_MAX
#        define INT_LEAST64_MIN		LONG_MIN
#        define INT_LEAST64_MAX		LONG_MAX
#        define INT_FAST64_MIN		LONG_MIN
#        define INT_FAST64_MAX		LONG_MAX
#        define UINT64_MAX			ULONG_MAX
#        define UINT_LEAST64_MAX		ULONG_MAX
#        define UINT_FAST64_MAX		ULONG_MAX
#      else
#        error iris not support
#      endif
#    elif	defined(IRIS_BORLANDC) || defined(IRIS_MSC)
#      if		!defined(_IRIS_SUPPORT_INT128)
#        define INTMAX_MIN			_I64_MIN
#        define INTMAX_MAX			_I64_MAX
#        define UINTMAX_MAX			_UI64_MAX
#      endif
#      define INT64_MIN				_I64_MIN
#      define INT64_MAX				_I64_MAX
#      define INT_LEAST64_MIN			_I64_MIN
#      define INT_LEAST64_MAX			_I64_MAX
#      define INT_FAST64_MIN			_I64_MIN
#      define INT_FAST64_MAX			_I64_MAX
#      define UINT64_MAX				_UI64_MAX
#      define UINT_LEAST64_MAX		_UI64_MAX
#      define UINT_FAST64_MAX			_UI64_MAX
#    else
#      if		!defined(_IRIS_SUPPORT_INT128)
#        define INTMAX_MIN		INT32_MIN
#        define INTMAX_MAX		INT32_MAX
#        define UINTMAX_MIN		UINT32_MAX
#      endif
#    endif	// 64
#    if	defined(_IRIS_SUPPORT_INT128)	// 128
#      define INTMAX_MIN				_I128_MIN
#      define INTMAX_MAX				_I128_MAX
#      define UINTMAX_MIN				_UI128_MAX
#      define INT128_MIN				_I128_MIN
#      define INT128_MAX				_I128_MAX
#      define INT_LEAST128_MIN		_I128_MIN
#      define INT_LEAST128_MAX		_I128_MAX
#      define INT_FAST128_MIN			_I128_MIN
#      define INT_FAST128_MAX			_I128_MAX
#      define UINT128_MAX				_UI128_MAX
#      define UINT_LEAST128_MAX		_UI128_MAX
#      define UINT_FAST128_MAX		_UI128_MAX
#    endif	// 128
#  endif	// defined(__STDC_LIMIT_MACROS)
#  if	defined(__STDC_FORMAT_MACROS)
#    define PRId8				"d"
#    define PRIi8				"i"
#    define PRIu8				"u"
#    define PRIo8				"o"
#    define PRIx8				"x"
#    define PRIdLEAST8			"d"
#    define PRIiLEAST8			"i"
#    define PRIuLEAST8			"u"
#    define PRIoLEAST8			"o"
#    define PRIxLEAST8			"x"
#    define PRIdFAST8			"d"
#    define PRIiFAST8			"i"
#    define PRIuFAST8			"u"
#    define PRIoFAST8			"o"
#    define PRIxFAST8			"x"
#    define SCNd8				"d"
#    define SCNi8				"i"
#    define SCNu8				"u"
#    define SCNo8				"o"
#    define SCNx8				"x"
#    define SCNdLEAST8			"d"
#    define SCNiLEAST8			"i"
#    define SCNuLEAST8			"u"
#    define SCNoLEAST8			"o"
#    define SCNxLEAST8			"x"
#    define SCNdFAST8			"d"
#    define SCNiFAST8			"i"
#    define SCNuFAST8			"u"
#    define SCNoFAST8			"o"
#    define SCNxFAST8			"x"
#    define PRId16			"d"
#    define PRIi16			"i"
#    define PRIu16			"u"
#    define PRIo16			"o"
#    define PRIx16			"x"
#    define PRIdLEAST16		"d"
#    define PRIiLEAST16		"i"
#    define PRIuLEAST16		"u"
#    define PRIoLEAST16		"o"
#    define PRIxLEAST16		"x"
#    define PRIdFAST16		"d"
#    define PRIiFAST16		"i"
#    define PRIuFAST16		"u"
#    define PRIoFAST16		"o"
#    define PRIxFAST16		"x"
#    define SCNd16			"d"
#    define SCNi16			"i"
#    define SCNu16			"u"
#    define SCNo16			"o"
#    define SCNx16			"x"
#    define SCNdLEAST16		"d"
#    define SCNiLEAST16		"i"
#    define SCNuLEAST16		"u"
#    define SCNoLEAST16		"o"
#    define SCNxLEAST16		"x"
#    define SCNdFAST16		"d"
#    define SCNiFAST16		"i"
#    define SCNuFAST16		"u"
#    define SCNoFAST16		"o"
#    define SCNxFAST16		"x"
#    if	(ULONG_MAX == 0xFFFFFFFF)	// 32
#      define PRId32			"ld"
#      define PRIi32			"li"
#      define PRIu32			"lu"
#      define PRIo32			"lo"
#      define PRIx32			"lx"
#      define PRIdLEAST32		"ld"
#      define PRIiLEAST32		"li"
#      define PRIuLEAST32		"lu"
#      define PRIoLEAST32		"lo"
#      define PRIxLEAST32		"lx"
#      define PRIdFAST32		"ld"
#      define PRIiFAST32		"li"
#      define PRIuFAST32		"lu"
#      define PRIoFAST32		"lo"
#      define PRIxFAST32		"lx"
#      define SCNd32			"ld"
#      define SCNi32			"li"
#      define SCNu32			"lu"
#      define SCNo32			"lo"
#      define SCNx32			"lx"
#      define SCNdLEAST32		"ld"
#      define SCNiLEAST32		"li"
#      define SCNuLEAST32		"lu"
#      define SCNoLEAST32		"lo"
#      define SCNxLEAST32		"lx"
#      define SCNdFAST32		"ld"
#      define SCNiFAST32		"li"
#      define SCNuFAST32		"lu"
#      define SCNoFAST32		"lo"
#      define SCNxFAST32		"lx"
#    elif	(UINT_MAX = 0xFFFFFFFF)
#      define PRId32			"d"
#      define PRIi32			"i"
#      define PRIu32			"u"
#      define PRIo32			"o"
#      define PRIx32			"x"
#      define PRIdLEAST32		"d"
#      define PRIiLEAST32		"i"
#      define PRIuLEAST32		"u"
#      define PRIoLEAST32		"o"
#      define PRIxLEAST32		"x"
#      define PRIdFAST32		"d"
#      define PRIiFAST32		"i"
#      define PRIuFAST32		"u"
#      define PRIoFAST32		"o"
#      define PRIxFAST32		"x"
#      define SCNd32			"d"
#      define SCNi32			"i"
#      define SCNu32			"u"
#      define SCNo32			"o"
#      define SCNx32			"x"
#      define SCNdLEAST32		"d"
#      define SCNiLEAST32		"i"
#      define SCNuLEAST32		"u"
#      define SCNoLEAST32		"o"
#      define SCNxLEAST32		"x"
#      define SCNdFAST32		"d"
#      define SCNiFAST32		"i"
#      define SCNuFAST32		"u"
#      define SCNoFAST32		"o"
#      define SCNxFAST32		"x"
#    else
#      error iris not support
#    endif	// 32
#    if	!defined(_IRIS_NOT_SUPPORT_LLONG) && (ULLONG_MAX == 18446744073709551615ULL)	// 64
#      if		!defined(_IRIS_SUPPORT_INT128)
#        define PRIdMAX			"lld"
#        define PRIiMAX			"lli"
#        define PRIuMAX			"llu"
#        define PRIoMAX			"llo"
#        define PRIxMAX			"llx"
#        define SCNdMAX			"lld"
#        define SCNiMAX			"lli"
#        define SCNuMAX			"llu"
#        define SCNoMAX			"llo"
#        define SCNxMAX			"llx"
#      endif
#      define PRId64			"lld"
#      define PRIi64			"lli"
#      define PRIu64			"llu"
#      define PRIo64			"llo"
#      define PRIx64			"llx"
#      define PRIdLEAST64		"lld"
#      define PRIiLEAST64		"lli"
#      define PRIuLEAST64		"llu"
#      define PRIoLEAST64		"llo"
#      define PRIxLEAST64		"llx"
#      define PRIdFAST64		"lld"
#      define PRIiFAST64		"lli"
#      define PRIuFAST64		"llu"
#      define PRIoFAST64		"llo"
#      define PRIxFAST64		"llx"
#      define SCNd64			"lld"
#      define SCNi64			"lli"
#      define SCNu64			"llu"
#      define SCNo64			"llo"
#      define SCNx64			"llx"
#      define SCNdLEAST64		"lld"
#      define SCNiLEAST64		"lli"
#      define SCNuLEAST64		"llu"
#      define SCNoLEAST64		"llo"
#      define SCNxLEAST64		"llx"
#      define SCNdFAST64		"lld"
#      define SCNiFAST64		"lli"
#      define SCNuFAST64		"llu"
#      define SCNoFAST64		"llo"
#      define SCNxFAST64		"llx"
#    elif	(ULONG_MAX != 0xFFFFFFFF)
#      if	(ULONG_MAX == 18446744073709551615)
#        if	!defined(_IRIS_SUPPORT_INT128)
#          define PRIdMAX			"ld"
#          define PRIiMAX			"li"
#          define PRIuMAX			"lu"
#          define PRIoMAX			"lo"
#          define PRIxMAX			"lx"
#          define SCNdMAX			"ld"
#          define SCNiMAX			"li"
#          define SCNuMAX			"lu"
#          define SCNoMAX			"lo"
#          define SCNxMAX			"lx"
#        endif
#        define PRId64			"ld"
#        define PRIi64			"li"
#        define PRIu64			"lu"
#        define PRIo64			"lo"
#        define PRIx64			"lx"
#        define PRIdLEAST64		"ld"
#        define PRIiLEAST64		"li"
#        define PRIuLEAST64		"lu"
#        define PRIoLEAST64		"lo"
#        define PRIxLEAST64		"lx"
#        define PRIdFAST64		"ld"
#        define PRIiFAST64		"li"
#        define PRIuFAST64		"lu"
#        define PRIoFAST64		"lo"
#        define PRIxFAST64		"lx"
#        define SCNd64			"ld"
#        define SCNi64			"li"
#        define SCNu64			"lu"
#        define SCNo64			"lo"
#        define SCNx64			"lx"
#        define SCNdLEAST64		"ld"
#        define SCNiLEAST64		"li"
#        define SCNuLEAST64		"lu"
#        define SCNoLEAST64		"lo"
#        define SCNxLEAST64		"lx"
#        define SCNdFAST64		"ld"
#        define SCNiFAST64		"li"
#        define SCNuFAST64		"lu"
#        define SCNoFAST64		"lo"
#        define SCNxFAST64		"lx"
#      else
#        error iris not support
#      endif
#    elif	defined(IRIS_BORLANDC) || defined(IRIS_MSC)
#      if		!defined(_IRIS_SUPPORT_INT128)
#        define PRIdMAX			"I64d"
#        define PRIiMAX			"I64i"
#        define PRIuMAX			"I64u"
#        define PRIoMAX			"I64o"
#        define PRIxMAX			"I64x"
#        define SCNdMAX			"I64d"
#        define SCNiMAX			"I64i"
#        define SCNuMAX			"I64u"
#        define SCNoMAX			"I64o"
#        define SCNxMAX			"I64x"
#      endif
#      define PRId64			"I64d"
#      define PRIi64			"I64i"
#      define PRIu64			"I64u"
#      define PRIo64			"I64o"
#      define PRIx64			"I64x"
#      define PRIdLEAST64		"I64d"
#      define PRIiLEAST64		"I64i"
#      define PRIuLEAST64		"I64u"
#      define PRIoLEAST64		"I64o"
#      define PRIxLEAST64		"I64x"
#      define PRIdFAST64		"I64d"
#      define PRIiFAST64		"I64i"
#      define PRIuFAST64		"I64u"
#      define PRIoFAST64		"I64o"
#      define PRIxFAST64		"I64x"
#      define SCNd64			"I64d"
#      define SCNi64			"I64i"
#      define SCNu64			"I64u"
#      define SCNo64			"I64o"
#      define SCNx64			"I64x"
#      define SCNdLEAST64		"I64d"
#      define SCNiLEAST64		"I64i"
#      define SCNuLEAST64		"I64u"
#      define SCNoLEAST64		"I64o"
#      define SCNxLEAST64		"I64x"
#      define SCNdFAST64		"I64d"
#      define SCNiFAST64		"I64i"
#      define SCNuFAST64		"I64u"
#      define SCNoFAST64		"I64o"
#      define SCNxFAST64		"I64x"
#    else
#      if		!defined(_IRIS_SUPPORT_INT128)
#        define PRIdMAX			"I128d"
#        define PRIiMAX			"I128i"
#        define PRIuMAX			"I128u"
#        define PRIoMAX			"I128o"
#        define PRIxMAX			"I128x"
#        define SCNdMAX			"I128d"
#        define SCNiMAX			"I128i"
#        define SCNuMAX			"I128u"
#        define SCNoMAX			"I128o"
#        define SCNxMAX			"I128x"
#      endif
#    endif	// 64
#    if	defined(_IRIS_SUPPORT_INT128)	// 128
#      define PRId128				"I128d"
#      define PRIi128				"I128i"
#      define PRIu128				"I128u"
#      define PRIo128				"I128o"
#      define PRIx128				"I128x"
#      define PRIdLEAST128			"I128d"
#      define PRIiLEAST128			"I128i"
#      define PRIuLEAST128			"I128u"
#      define PRIoLEAST128			"I128o"
#      define PRIxLEAST128			"I128x"
#      define PRIdFAST128			"I128d"
#      define PRIiFAST128			"I128i"
#      define PRIuFAST128			"I128u"
#      define PRIoFAST128			"I128o"
#      define PRIxFAST128			"I128x"
#      define SCNd128				"I128d"
#      define SCNi128				"I128i"
#      define SCNu128				"I128u"
#      define SCNo128				"I128o"
#      define SCNx128				"I128x"
#      define SCNdLEAST128			"I128d"
#      define SCNiLEAST128			"I128i"
#      define SCNuLEAST128			"I128u"
#      define SCNoLEAST128			"I128o"
#      define SCNxLEAST128			"I128x"
#      define SCNdFAST128			"I128d"
#      define SCNiFAST128			"I128i"
#      define SCNuFAST128			"I128u"
#      define SCNoFAST128			"I128o"
#      define SCNxFAST128			"I128x"
#    endif
#  endif

// function
STATICINLINE intmax_t		strtoimax(LPCSTR restrict s, CHAR** restrict endptr, int base)
{
	IRIS_UNUSED_VARIABLE(s);
	IRIS_UNUSED_VARIABLE(endptr);
	IRIS_UNUSED_VARIABLE(base);
	// TODO : Ή
	return 0;
}
STATICINLINE uintmax_t		strtouimax(LPCSTR restrict s, CHAR** restrict endptr, int base)
{
	IRIS_UNUSED_VARIABLE(s);
	IRIS_UNUSED_VARIABLE(endptr);
	IRIS_UNUSED_VARIABLE(base);
	// TODO : Ή
	return 0;
}
STATICINLINE intmax_t		wcstoimax(LPCWSTR restrict s, WCHAR** restrict endptr, int base)
{
	IRIS_UNUSED_VARIABLE(s);
	IRIS_UNUSED_VARIABLE(endptr);
	IRIS_UNUSED_VARIABLE(base);
	// TODO : Ή
	return 0;
}
STATICINLINE uintmax_t		wcstouimax(LPCWSTR restrict s, WCHAR** restrict endptr, int base)
{
	IRIS_UNUSED_VARIABLE(s);
	IRIS_UNUSED_VARIABLE(endptr);
	IRIS_UNUSED_VARIABLE(base);
	// TODO : Ή
	return 0;
}


#endif

#endif

#endif
