//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_intrinsics.h
 * @brief		gݍ݊֐`t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_intrinsics_H_
#define INCG_IRIS_iris_intrinsics_H_

//======================================================================
// include

//======================================================================
// define
#if	defined(_MSC_FULL_VER) && (_MSC_FULL_VER >= 140050215)
#define IRIS_IS_UNION(T)	(__is_union(T))
#define IRIS_IS_POD(T)		(__is_pod(T) && __has_trivial_constructor(T))
#define IRIS_IS_EMPTY(T)	(__is_empty(T))

#define IRIS_HAS_TRIVIAL_CONSTRUCTOR(T)		(__has_trivial_constructor(T))
#define IRIS_HAS_TRIVIAL_COPY(T)			(__has_trivial_copy(T))
#define IRIS_HAS_TRIVIAL_ASSIGN(T)			(__has_trivial_assign(T))
#define IRIS_HAS_TRIVIAL_DESTRUCTOR(T)		(__has_trivial_destructor(T))

#define IRIS_HAS_NOTHROW_CONSTRUCTOR(T)		(__has_nothrow_constructor(T))
#define IRIS_HAS_NOTHROW_COPY(T)			(__has_nothrow_copy(T))
#define IRIS_HAS_NOTHROW_ASSIGN(T)			(__has_nothrow_assign(T))
#define IRIS_HAS_VIRTUAL_DESTRUCTOR(T)		(__has_virtual_destructor(T))

#if _MANAGED
#define IRIS_HAS_TYPE_TRAITS_INTRINSICS
#endif

#else
#endif	// #if	defined(_MSC_FULL_VER) && (_MSC_FULL_VER >= 140050215)

#ifndef IRIS_IS_UNION
#define IRIS_IS_UNION(T)	false
#endif

#ifndef IRIS_IS_POD
#define IRIS_IS_POD(T)		false
#endif

#ifndef IRIS_IS_EMPTY
#define IRIS_IS_EMPTY(T)	false
#endif

#ifndef IRIS_HAS_TRIVIAL_CONSTRUCTOR
#define IRIS_HAS_TRIVIAL_CONSTRUCTOR(T)	false
#endif

#ifndef IRIS_HAS_TRIVIAL_COPY
#define IRIS_HAS_TRIVIAL_COPY(T)		false
#endif

#ifndef IRIS_HAS_TRIVIAL_ASSIGN
#define IRIS_HAS_TRIVIAL_ASSIGN(T)		false
#endif

#ifndef IRIS_HAS_TRIVIAL_DESTRUCTOR
#define	IRIS_HAS_TRIVIAL_DESTRUCTOR(T)	false
#endif

#ifndef IRIS_HAS_NOTHROW_CONSTRUCTOR
#define IRIS_HAS_NOTHROW_CONSTRUCTOR(T)	false
#endif

#ifndef IRIS_HAS_NOTHROW_COPY
#define IRIS_HAS_NOTHROW_COPY(T)		false
#endif

#ifndef IRIS_HAS_NOTHROW_ASSIGN
#define IRIS_HAS_NOTHROW_ASSIGN(T)		false
#endif

#ifndef IRIS_HAS_VIRTUAL_DESTRUCTOR
#define IRIS_HAS_VIRTUAL_DESTRUCTOR(T)	false
#endif

#endif
