//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_declspec.h
 * @brief		__declspec LqqΉ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_declspec_H_
#define INCG_IRIS_iris_declspec_H_

//======================================================================
// include
#include "iris_compiler.h"

//======================================================================
// define
//--------------------
// deprecate
#ifndef IRIS_DEPRECATE
#  if	defined(IRIS_WIN32)
#    define	IRIS_DEPRECATE			__declspec(deprecated)
#  else
#    define	IRIS_DEPRECATE		
#  endif
#endif

#ifndef IRIS_DEPRECATE_MSG
#  if	defined(IRIS_WIN32)
#    define	IRIS_DEPRECATE_MSG(_txt)	__declspec(deprecated(_txt))
#  else
#    define	IRIS_DEPRECATE_MSG(_txt)
#  endif
#endif

//--------------------
// dll import/export
#ifndef	IRIS_DLLEXPORT
#  if	defined(IRIS_WIN32)
#    if		defined(_USRDLL)
#      define IRIS_DLLEXPORT	__declspec(dllexport)
#    else
#      define IRIS_DLLEXPORT	__declspec(dllimport)
#    endif
#  else
#    define IRIS_DLLEXPORT	
#  endif
#endif
#ifndef	IRIS_DLLIMPORT
#  if	defined(IRIS_WIN32)
#    if		defined(_USRDLL)
#      define IRIS_DLLIMPORT	__declspec(dllimport)
#    else
#      define IRIS_DLLIMPORT	__declspec(dllexport)
#    endif
#  else
#    define IRIS_DLLIMPORT	
#  endif
#endif

//--------------------
// selectany
#ifndef	IRIS_SELECTANY
#  if	defined(IRIS_MSC) || defined(IRIS_BORLANDC)
#    define IRIS_SELECTANY		__declspec(selectany)
#  else
#    define IRIS_SELECTANY
#  endif
#endif

#endif
