//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLUT.h
 * @brief		glut T|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGLUT_H_
#define INCG_IRIS_GXGLUT_H_

//======================================================================
// include
#include "../../../iris_inchead.h"
#if	defined(__glut_h__)
#  define _IRIS_SUPPORT_GLUT
#endif

#ifdef _IRIS_SUPPORT_GLUT
#  if		defined(_WIN32)
#    include <GL/glut.h>
#  elif		(defined(__APPLE__) || defined(__MACH__))
#    include <GLUT/glut.h>
#  endif
#endif

//======================================================================
// define
#define GXGLUT_RGB			GLUT_RGB			
#define GXGLUT_RGBA			GLUT_RGBA			
#define GXGLUT_INDEX		GLUT_INDEX		
#define GXGLUT_SINGLE		GLUT_SINGLE		
#define GXGLUT_DOUBLE		GLUT_DOUBLE		
#define GXGLUT_ACCUM		GLUT_ACCUM		
#define GXGLUT_ALPHA		GLUT_ALPHA		
#define GXGLUT_DEPTH		GLUT_DEPTH		
#define GXGLUT_STENCIL		GLUT_STENCIL		
#define GXGLUT_MULTISAMPLE	GLUT_MULTISAMPLE	
#define GXGLUT_STEREO		GLUT_STEREO		
#define GXGLUT_LUMINANCE	GLUT_LUMINANCE

#if	defined(GLUTCALLBACK)
#  define GXGLUTCALLBACK		GLUTCALLBACK
#else
#  if	defined(IRIS_WIN32)
#    define GXGLUTCALLBACK		__cdecl
#  else
#    define GXGLUTCALLBACK		
#  endif
#endif

#define	GXGLUT_USEDEFAULT	((int)0x80000000)

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// function
/// glut̏
void	gxglutInit(int* argcp, char** argv);
/// DisplayModȅ
void	gxglutInitDisplayMode(unsigned int mode);
/// EBhEʒȕ
void	gxglutInitWindowPosition(int x, int y);
/// EBhETCY̏
void	gxglutInitWindowSize(int width, int height);
/// C[v
void	gxglutMainLoop(void);
/// EBhE̍쐬
int		gxglutCreateWindow(const char* title);
/// EBhE̔j
void	gxglutDestroyWindow(int win);
/// SwapBuffers
void	gxglutSwapBuffers(void);

/// EBhEʃnh̎擾
int		gxglutGetWindow(void);
/// EBhE^Cg̐ݒ
void	gxglutSetWindowTitle(const char *title);
/// EBhE̕\
void	gxglutShowWindow(void);
/// EBhE̔\
void	gxglutHideWindow(void);

/// p[^擾֐
int		gxglutGet(unsigned int type);

/// `֐̓o^
void	gxglutDisplayFunc(void (GXGLUTCALLBACK *func)(void));
/// TCYύX֐̓o^
void	gxglutReshapeFunc(void (GXGLUTCALLBACK *func)(int width, int height));
/// ACh֐̓o^
void	gxglutIdleFunc(void (GXGLUTCALLBACK *func)(void));

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#ifndef _IRIS_SUPPORT_GLUT

//======================================================================
// define
#define GLUT_RGB			0
#define GLUT_RGBA			GLUT_RGB
#define GLUT_INDEX			1
#define GLUT_SINGLE			0
#define GLUT_DOUBLE			2
#define GLUT_ACCUM			4
#define GLUT_ALPHA			8
#define GLUT_DEPTH			16
#define GLUT_STENCIL		32
#define GLUT_MULTISAMPLE	128
#define GLUT_STEREO			256
#define GLUT_LUMINANCE		512

#endif

#endif
