//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLUT.cpp
 * @brief		glut T|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_GXGLUT_CPP_

//======================================================================
// include
#include "GXGLUT.h"

#ifndef _IRIS_SUPPORT_GLUT
#  include <stdlib.h>
#  include "../../../iris_debug.h"
#endif

//======================================================================
// link
#ifndef _IRIS_SUPPORT_GLUT
#  if		defined(IRIS_WIN32)
#    pragma comment( lib, "OpenGL32.lib" ) 
#  endif
#endif

namespace iris {
namespace gx {
namespace gl
{

#ifdef _IRIS_SUPPORT_GLUT

//======================================================================
// function
void	gxglutInit(int* argcp, char** argv)			{ glutInit(argcp, argv); }
void	gxglutInitDisplayMode(unsigned int mode)	{ glutInitDisplayMode(mode); }
void	gxglutInitWindowPosition(int x, int y)		
{
	if( x == GXGLUT_USEDEFAULT ) x=100, y=100;
	glutInitWindowPosition(x, y); 
}
void	gxglutInitWindowSize(int width, int height)
{
	if( width == GXGLUT_USEDEFAULT ) width=640, height=480;
	glutInitWindowSize(width, height); 
}
void	gxglutMainLoop(void)						{ glutMainLoop(); }
int		gxglutCreateWindow(const char* title)		{ return glutCreateWindow(title); }
void	gxglutDestroyWindow(int win)				{ glutDestroyWindow(win); }
void	gxglutSwapBuffers(void)						{ glutSwapBuffers(); }
int		gxglutGetWindow(void)						{ return glutGetWindow(); }
void	gxglutSetWindowTitle(const char *title)		{ glutSetWindowTitle(title); }
void	gxglutShowWindow(void)						{ glutShowWindow(); }
void	gxglutHideWindow(void)						{ glutHideWindow(); }
int		gxglutGet(unsigned int type)				{ return glutGet(type); }
void	gxglutDisplayFunc(void (GXGLUTCALLBACK *func)(void))					{ glutDisplayFunc(func); }
void	gxglutReshapeFunc(void (GXGLUTCALLBACK *func)(int width, int height))	{ glutReshapeFunc(func); }
void	gxglutIdleFunc(void (GXGLUTCALLBACK *func)(void))						{ glutIdleFunc(func); }

#else

//======================================================================
// typedef
typedef void	(GXGLUTCALLBACK *PFN_GXGLUTDraw)(void);			//!< `֐
typedef void	(GXGLUTCALLBACK *PFN_GXGLUTReshape)(int w, int h);	//!< TCYύX֐
typedef void	(GXGLUTCALLBACK *PFN_GXGLUTIdle)(void);			//!< ACh֐

//======================================================================
// variable
namespace
{
static	PFN_GXGLUTDraw		s_pfnDraw		= nullptr;
static	PFN_GXGLUTReshape	s_pfnReshape	= nullptr;
static	PFN_GXGLUTIdle		s_pfnIdle		= nullptr;
static	int			s_gxglut_wnd_pos_x = 0;
static	int			s_gxglut_wnd_pos_y = 0;
static	int			s_gxglut_wnd_w = 0;
static	int			s_gxglut_wnd_h = 0;
static	IrisUInt	s_gxglut_disp_mode = 0;
}

#if		defined(IRIS_WIN32) && !defined(IRIS_WIN32_WCE)

//======================================================================
// struct
typedef struct 
{
	HWND					hWnd;	//!< EBhEnh
	PIXELFORMATDESCRIPTOR	pfd;	//!< sNZtH[}bg
	HGLRC					hRC;	//!< ReLXg
	HDC						hDC;	//!< foCXReLXg
} GXGLUT_INNER_PARAM;

//======================================================================
// variable
static GXGLUT_INNER_PARAM	s_gxglut_param;

//======================================================================
// declare
static LRESULT CALLBACK GXGLUTWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
static void		ExitGXGLUT(void);

//======================================================================
// function
// glut̏
void	gxglutInit(int* argcp, char** argv)	{}
// DisplayModȅ
void	gxglutInitDisplayMode(unsigned int mode)
{
	s_gxglut_disp_mode = mode;
}
// EBhEʒȕ
void	gxglutInitWindowPosition(int x, int y)
{
	s_gxglut_wnd_pos_x = x;
	s_gxglut_wnd_pos_y = y;
}
// EBhETCY̏
void	gxglutInitWindowSize(int width, int height)
{
	s_gxglut_wnd_w = width;
	s_gxglut_wnd_h = height;
}
// C[v
void	gxglutMainLoop(void)
{
	MSG msg;
	ZeroMemory(&msg, sizeof(msg));
	while(msg.message != WM_QUIT) 
	{
		while( !PeekMessage(&msg, nullptr, 0U, 0U, PM_NOREMOVE) ) 
		{
			if( s_pfnIdle != nullptr ) (*s_pfnIdle)();
		}
		if(GetMessage(&msg, nullptr, 0, 0))
		{
			if( !TranslateAccelerator(s_gxglut_param.hWnd, nullptr, &msg) )
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}
	ExitGXGLUT();
	HINSTANCE hInstance = GetModuleHandle(nullptr);
	UnregisterClass(IRIS_TEXT("gxglut window"), hInstance);
	exit(0);
}
// EBhE̍쐬
int		gxglutCreateWindow(const char* title)
{
	HINSTANCE hInstance = GetModuleHandle(nullptr);
	WNDCLASSEX wcex;
	wcex.cbSize = sizeof(WNDCLASSEX);
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= GXGLUTWndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= nullptr;
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= nullptr;
	wcex.lpszClassName	= IRIS_TEXT("ilut window");
	wcex.hIconSm		= nullptr;

	RegisterClassEx(&wcex);

	IRIS_ASSERT( s_gxglut_param.hWnd == nullptr );
	HWND hWnd = CreateWindow(IRIS_TEXT("ilut window"), IRIS_TEXT(""), WS_OVERLAPPEDWINDOW,
		s_gxglut_wnd_pos_x, s_gxglut_wnd_pos_y, s_gxglut_wnd_w, s_gxglut_wnd_h, nullptr, nullptr, hInstance, nullptr);

	memset(&s_gxglut_param.pfd, 0, sizeof(s_gxglut_param.pfd));
	s_gxglut_param.pfd.nSize		= sizeof(s_gxglut_param.pfd);
	s_gxglut_param.pfd.nVersion		= 1;
	s_gxglut_param.pfd.dwFlags		= PFD_DRAW_TO_WINDOW	// WindowX^C
									| PFD_SUPPORT_OPENGL;	// OpenGL
	s_gxglut_param.pfd.iPixelType	= PFD_TYPE_RGBA;
	s_gxglut_param.pfd.cColorBits	= 24;	// F
	s_gxglut_param.pfd.cDepthBits	= 16;	// [x
	s_gxglut_param.pfd.cStencilBits	= 0;	// XeV
	s_gxglut_param.pfd.iLayerType	= PFD_MAIN_PLANE;	// C[^Cv

	if( s_gxglut_disp_mode & GXGLUT_DOUBLE )	s_gxglut_param.pfd.dwFlags |= PFD_DOUBLEBUFFER;	// _uobt@gp\
	if( s_gxglut_disp_mode & GXGLUT_INDEX )		s_gxglut_param.pfd.iPixelType = PFD_TYPE_COLORINDEX;	// index

	SetWindowTextA(hWnd, title);
	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);
	HDC hDC = GetDC(hWnd);
	int pixelformat = ChoosePixelFormat(hDC, &s_gxglut_param.pfd);
	if( pixelformat == 0 ) { IRIS_WARNING("ChoosePixelFormat Failed..."); }
	if( !SetPixelFormat(hDC, pixelformat, &s_gxglut_param.pfd) ) { IRIS_WARNING("SetPixelFormat Failed..."); }

	HGLRC hRC = wglCreateContext(hDC);
	s_gxglut_param.hRC	= hRC;
	s_gxglut_param.hDC	= hDC;
	s_gxglut_param.hWnd	= hWnd;
	wglMakeCurrent(hDC, hRC);
	return reinterpret_cast<int>(hWnd);
}
// EBhE̔j
void	gxglutDestroyWindow(int win)
{
	DestroyWindow(reinterpret_cast<HWND>(win));
}
// SwapBuffers
void	gxglutSwapBuffers(void)
{
	HDC hDC = wglGetCurrentDC();
	SwapBuffers(hDC);
}
// EBhEʃnh̎擾
int		gxglutGetWindow(void)						{ return reinterpret_cast<int>(s_gxglut_param.hWnd); }
// EBhE^Cg̐ݒ
void	gxglutSetWindowTitle(const char *title)		{ SetWindowTextA(s_gxglut_param.hWnd, title); }
// EBhE̕\
void	gxglutShowWindow(void)						{ ShowWindow(s_gxglut_param.hWnd, SW_SHOW); }
// EBhE̔\
void	gxglutHideWindow(void)						{ ShowWindow(s_gxglut_param.hWnd, SW_HIDE); }
// p[^擾֐
int		gxglutGet(unsigned int type)				{ return 0; }	// TODO : 

// `֐̓o^
void	gxglutDisplayFunc(void (GXGLUTCALLBACK *func)(void))					{ s_pfnDraw = func; }
// TCYύX֐̓o^
void	gxglutReshapeFunc(void (GXGLUTCALLBACK *func)(int width, int height))	{ s_pfnReshape = func; }
// ACh֐̓o^
void	gxglutIdleFunc(void (GXGLUTCALLBACK *func)(void))						{ s_pfnIdle = func; }

// EBhEvV[W
LRESULT CALLBACK GXGLUTWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
	case WM_COMMAND:
		break;
	case WM_SIZE:
		if( s_pfnReshape != nullptr ) (*s_pfnReshape)(LOWORD(lParam), HIWORD(lParam));
		break;
	case WM_PAINT:
		if( s_pfnDraw != nullptr ) (*s_pfnDraw)();
		ValidateRect(hWnd, nullptr);
		break;
	case WM_DESTROY:
		ExitGXGLUT();
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	};
	return 0;
}

void ExitGXGLUT(void)
{
	wglMakeCurrent(nullptr, nullptr);
	if( s_gxglut_param.hRC != nullptr )	wglDeleteContext(s_gxglut_param.hRC);
	if( s_gxglut_param.hDC != nullptr )	ReleaseDC(s_gxglut_param.hWnd, s_gxglut_param.hDC);

	s_gxglut_param.hRC	= nullptr;
	s_gxglut_param.hDC	= nullptr;
	s_gxglut_param.hWnd	= nullptr;

	s_pfnDraw			= nullptr;
	s_pfnReshape		= nullptr;
	s_pfnIdle			= nullptr;
}

#else

//======================================================================
// function

void	gxglutInit(int* /*argcp*/, char** /*argv*/)				{}
void	gxglutInitDisplayMode(unsigned int /*mode*/)			{}
void	gxglutInitWindowPosition(int /*x*/, int /*y*/)			{}
void	gxglutInitWindowSize(int /*width*/, int /*height*/)		{}
void	gxglutMainLoop(void)									{}
int		gxglutCreateWindow(const char* /*title*/)				{ return 0; }
void	gxglutDestroyWindow(int /*win*/)						{}
void	gxglutSwapBuffers(void)									{}
int		gxglutGetWindow(void)									{ return 0; }
void	gxglutSetWindowTitle(const char* /*title*/)				{}
void	gxglutShowWindow(void)									{}
void	gxglutHideWindow(void)									{}
int		gxglutGet(unsigned int /*type*/)							{ return 0; }
void	gxglutDisplayFunc(void (GXGLUTCALLBACK *func)(void))					{ s_pfnDraw		= func; }
void	gxglutReshapeFunc(void (GXGLUTCALLBACK *func)(int width, int height))	{ s_pfnReshape	= func; }
void	gxglutIdleFunc(void (GXGLUTCALLBACK *func)(void))						{ s_pfnIdle		= func; }

#endif

#endif

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris
