//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLShader.h
 * @brief		GLSL VF[_[IuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGLShader_H_
#define INCG_IRIS_GXGLShader_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "GXGLSL.h"

#if	defined(_IRIS_SUPPORT_OPENGL)

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// class
//! GLSL VF[_[IuWFNgNX
class CGLShader : public INonCopyable<>
{
private:
	GLuint			m_Shader;	//!< VF[_[IuWFNg
public:
	// RXgN^
	CGLShader(void);
	// fXgN^
	~CGLShader(void);

public:
	/// IuWFNg̎擾Iy[^
	GLuint	operator ()(void)	{ return GetShaderObject(); }

public:
	// IuWFNg̍쐬
	bool	Create(GLenum Type);
	// IuWFNg̍폜
	void	Delete(void);

public:
	// \[XvO̓ǂݍ
	bool	Load(LPCSTR pName);
	// RpC
	bool	Compile(void);
	// O̎擾
	GLsizei	GetInfoLog(LPSTR pString, GLsizei nSize);

public:
	/// IuWFNg̎擾
	GLuint	GetShaderObject(void)	{ return m_Shader; }

	/// ̎擾
	void	getiv(GLenum name, GLint* param)	{ glGetShaderiv(m_Shader, name, param); }
};


}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
