//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLEWError.h
 * @brief		GLEW G[T|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGLEWError_H_
#define INCG_IRIS_GXGLEWError_H_

//======================================================================
// include
#include "../../../iris_debug.h"

//======================================================================
// define
#define GXGLEW_SUCCEEDED(result)			(result == GLEW_OK)
#define GXGLEW_FAILED(result)				(result != GLEW_OK)

#ifdef _IRIS_DEBUG

#define GXGLEW_ERROR(Error)					do { if( GXGLEW_FAILED(Error) ) { dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) :<%s>.\n")  , __LINE__, ::iris::gx::gl::gxglewGetErrorString(Error)); } } while(0)
#define GXGLEW_ERROR2(Error, comm)			do { if( GXGLEW_FAILED(Error) ) { dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s:<%s>.\n"), __LINE__, comm, ::iris::gx::gl::gxglewGetErrorString(Error)); } } while(0)
#define GXGLEW_CHECK_RESULT(exp)			do { GLenum Error = (exp); if( GXGLEW_FAILED(Error) ) {				\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n")		\
													, __LINE__, TEXT(#exp), ::iris::gx::gl::gxglewGetErrorString(Error)); \
											} } while(0)
#define GXGLEW_DO_CHECK_RESULT(exp, todo)	do { GLenum Error = (exp); if( GXGLEW_FAILED(Error) ) {							\
												dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n")		\
													, __LINE__, TEXT(#exp), ::iris::gx::gl::gxglewGetErrorString(Error)); \
												todo;																		\
											} } while(0)

#else

#define GXGLEW_ERROR(Error)					(void)(0)
#define GXGLEW_ERROR2(Error,comm)			(void)(0)
#define GXGLEW_CHECK_RESULT(exp)			exp
#define GXGLEW_DO_CHECK_RESULT(exp, todo)	do { if( GXGLEW_FAILED(exp) ) { todo; } } while(0)

#endif

#endif
