//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLEW.h
 * @brief		GLEWT|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGLEW_H_
#define INCG_IRIS_GXGLEW_H_

//======================================================================
// include
#include "../../../iris_inchead.h"
#include "../../../iris_debug.h"

#if		defined(_IRIS_SUPPORT_OPENGL)
#  if		defined(__glew_h__) || defined(__GLEW_H__)
#    define _IRIS_SUPPORT_GLEW
#  endif
#  ifdef _IRIS_SUPPORT_GLEW
#    include "gl/glew.h"
#    include "../gxgl_inchead.h"
#  else
#    ifdef GL_GLEXT_PROTOTYPES
#      undef GL_GLEXT_PROTOTYPES
#    endif
#    include "../gxgl_inchead.h"
#    include <gl/glext.h>
#  endif

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// function
// glew̏
bool	gxglewInit(void);
// glext̎w@\pł邩ǂ
bool	gxglewGetExtension(LPCSTR pFunction);
// glew̃G[o
LPCSTR	gxglewGetErrorString(GLenum Error);
// glew̕擾
LPCSTR	gxglewGetString(GLenum Name);
//
PROC	gxglewGetProcAddress(LPCSTR pFunction);

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#if	!defined(_IRIS_SUPPORT_GLEW)

//======================================================================
// extern

//======================================================================
// define
#define GLEW_VERSION			1

#define GLEW_OK					0

#define GLEW_GET_FUN(x)			x
#define GLEW_GET_VAR(x)			x

#define GLEW_FUN_EXPORT			extern
#define GLEW_VAR_EXPORT			extern


// glBlendEquationEXT
#define glBlendEquationEXT		GLEW_GET_FUN(__glewBlendEquationEXT)
#define GLEW_EXT_blend_minmax	GLEW_GET_VAR(__GLEW_EXT_blend_minmax)
// glCreateShader
#define glCreateShader			GLEW_GET_FUN(__glewCreateShader)
// glDeleteShader
#define glDeleteShader			GLEW_GET_FUN(__glewDeleteShader)
// glShaderSource
#define glShaderSource			GLEW_GET_FUN(__glewShaderSource)
// glCompileShader
#define glCompileShader			GLEW_GET_FUN(__glewCompileShader)
// glGetShaderiv
#define glGetShaderiv			GLEW_GET_FUN(__glewGetShaderiv)
// glGetShaderInfoLog
#define glGetShaderInfoLog		GLEW_GET_FUN(__glewGetShaderInfoLog)


#define GLEW_ARB_shader_objects		GLEW_GET_VAR(__GLEW_ARB_shader_objects)
#define GLEW_ARB_vertex_shader		GLEW_GET_VAR(__GLEW_ARB_vertex_shader)
#define GLEW_ARB_fragment_shader	GLEW_GET_VAR(__GLEW_ARB_fragment_shader)

// glCreateProgram
#define glCreateProgram			GLEW_GET_FUN(__glewCreateProgram)
// glDeleteProgram
#define glDeleteProgram			GLEW_GET_FUN(__glewDeleteProgram)
// glAttachShader
#define glAttachShader			GLEW_GET_FUN(__glewAttachShader)
// glDetachShader
#define glDetachShader			GLEW_GET_FUN(__glewDetachShader)
// glUseProgram
#define glUseProgram			GLEW_GET_FUN(__glewUseProgram)
// glLinkProgram
#define glLinkProgram			GLEW_GET_FUN(__glewLinkProgram)
// glGetProgramiv
#define glGetProgramiv			GLEW_GET_FUN(__glewGetProgramiv)
// glGetProgramInfoLog
#define glGetProgramInfoLog		GLEW_GET_FUN(__glewGetProgramInfoLog)

//======================================================================
// extern
// glBlendEquationEXT
GLEW_FUN_EXPORT PFNGLBLENDEQUATIONEXTPROC	__glewBlendEquationEXT;
GLEW_VAR_EXPORT GLboolean					__GLEW_EXT_blend_minmax;
// glCreateShader
GLEW_FUN_EXPORT PFNGLCREATESHADERPROC		__glewCreateShader;
// glDeleteShader
GLEW_FUN_EXPORT PFNGLDELETESHADERPROC		__glewDeleteShader;
// glShaderSource
GLEW_FUN_EXPORT PFNGLSHADERSOURCEPROC		__glewShaderSource;
// glCompileShader
GLEW_FUN_EXPORT PFNGLCOMPILESHADERPROC		__glewCompileShader;
// glGetShaderiv
GLEW_FUN_EXPORT PFNGLGETSHADERIVPROC		__glewGetShaderiv;
// glGetShaderInfoLog
GLEW_FUN_EXPORT	PFNGLGETSHADERINFOLOGPROC	__glewGetShaderInfoLog;


GLEW_VAR_EXPORT GLboolean					__GLEW_ARB_shader_objects;
GLEW_VAR_EXPORT GLboolean					__GLEW_ARB_vertex_shader;
GLEW_VAR_EXPORT GLboolean					__GLEW_ARB_fragment_shader;

// glCreateProgram
GLEW_FUN_EXPORT	PFNGLCREATEPROGRAMPROC		__glewCreateProgram;
// glDeleteProgram
GLEW_FUN_EXPORT	PFNGLDELETEPROGRAMPROC		__glewDeleteProgram;
// glAttachShader
GLEW_FUN_EXPORT	PFNGLATTACHSHADERPROC		__glewAttachShader;
// glDetachShader
GLEW_FUN_EXPORT	PFNGLDETACHSHADERPROC		__glewDetachShader;
// glUseProgram
GLEW_FUN_EXPORT	PFNGLUSEPROGRAMPROC			__glewUseProgram;
// glLinkProgram
GLEW_FUN_EXPORT	PFNGLLINKPROGRAMPROC		__glewLinkProgram;
// glGetProgramiv
GLEW_FUN_EXPORT	PFNGLGETPROGRAMIVPROC		__glewGetProgramiv;
// glGetProgramInfoLog
GLEW_FUN_EXPORT	PFNGLGETPROGRAMINFOLOGPROC	__glewGetProgramInfoLog;

#endif


#endif

#endif
