//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLEW.cpp
 * @brief		GLEWT|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_GXGLEW_CPP_

//======================================================================
// include
#include "GXGLEW.h"
#include "GXGLEWError.h"

#if	defined(_IRIS_SUPPORT_OPENGL)

//======================================================================
// link
#ifdef _IRIS_SUPPORT_GLEW

#if		defined(_WIN32)
#pragma comment( lib, "glew32.lib" )
#endif

#endif

//======================================================================
// variable
#if	!defined(_IRIS_SUPPORT_GLEW)
// is supported variable
GLboolean	__GLEW_EXT_blend_minmax		= GL_FALSE;
GLboolean	__GLEW_ARB_shader_objects	= GL_FALSE;
GLboolean	__GLEW_ARB_vertex_shader	= GL_FALSE;
GLboolean	__GLEW_ARB_fragment_shader	= GL_FALSE;

// function pointer
PFNGLBLENDEQUATIONEXTPROC	__glewBlendEquationEXT	= nullptr;
PFNGLCREATESHADERPROC		__glewCreateShader		= nullptr;
PFNGLDELETESHADERPROC		__glewDeleteShader		= nullptr;
PFNGLSHADERSOURCEPROC		__glewShaderSource		= nullptr;
PFNGLCOMPILESHADERPROC		__glewCompileShader		= nullptr;
PFNGLGETSHADERIVPROC		__glewGetShaderiv		= nullptr;
PFNGLGETSHADERINFOLOGPROC	__glewGetShaderInfoLog	= nullptr;

PFNGLCREATEPROGRAMPROC		__glewCreateProgram		= nullptr;
PFNGLDELETEPROGRAMPROC		__glewDeleteProgram		= nullptr;
PFNGLATTACHSHADERPROC		__glewAttachShader		= nullptr;
PFNGLDETACHSHADERPROC		__glewDetachShader		= nullptr;
PFNGLUSEPROGRAMPROC			__glewUseProgram		= nullptr;
PFNGLLINKPROGRAMPROC		__glewLinkProgram		= nullptr;
PFNGLGETPROGRAMIVPROC		__glewGetProgramiv		= nullptr;
PFNGLGETPROGRAMINFOLOGPROC	__glewGetProgramInfoLog	= nullptr;
#endif

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// function
/**********************************************************************//**
 *
 * glew̏
 * 
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool gxglewInit(void)
{
#if		defined(_IRIS_SUPPORT_GLEW)
	GXGLEW_DO_CHECK_RESULT(glewInit(), return false);
	return true;
#elif	defined(_IRIS_SUPPORT_GLEXT)
	if( gxglewGetString(GL_EXTENSIONS) == nullptr ) return false;
	if( gxglewGetExtension("GL_EXT_blend_subtract") )
	{
		glBlendEquationEXT = reinterpret_cast<PFNGLBLENDEQUATIONEXTPROC>(gxglewGetProcAddress("glBlendEquationEXT"));
		GLEW_EXT_blend_minmax = GL_TRUE;
	}

	if( gxglewGetExtension("GL_ARB_shader_objects") )	GLEW_ARB_shader_objects		= GL_TRUE;
	if( gxglewGetExtension("GL_ARB_vertex_shader") )	GLEW_ARB_vertex_shader		= GL_TRUE;
	if( gxglewGetExtension("GL_ARB_fragment_shader") )	GLEW_ARB_fragment_shader	= GL_TRUE;

	glCreateShader		= reinterpret_cast<PFNGLCREATESHADERPROC>		(gxglewGetProcAddress("glCreateShader"));
	glDeleteShader		= reinterpret_cast<PFNGLDELETESHADERPROC>		(gxglewGetProcAddress("glDeleteShader"));
	glShaderSource		= reinterpret_cast<PFNGLSHADERSOURCEPROC>		(gxglewGetProcAddress("glShaderSource"));
	glCompileShader		= reinterpret_cast<PFNGLCOMPILESHADERPROC>		(gxglewGetProcAddress("glCompileShader"));
	glGetShaderiv		= reinterpret_cast<PFNGLGETSHADERIVPROC>		(gxglewGetProcAddress("glGetShaderiv"));
	glGetShaderInfoLog	= reinterpret_cast<PFNGLGETSHADERINFOLOGPROC>	(gxglewGetProcAddress("glGetShaderInfo"));

	glCreateProgram		= reinterpret_cast<PFNGLCREATEPROGRAMPROC>		(gxglewGetProcAddress("glCreateShader"));
	glDeleteProgram		= reinterpret_cast<PFNGLDELETEPROGRAMPROC>		(gxglewGetProcAddress("glDeleteShader"));
	glAttachShader		= reinterpret_cast<PFNGLATTACHSHADERPROC>		(gxglewGetProcAddress("glShaderSource"));
	glDetachShader		= reinterpret_cast<PFNGLDETACHSHADERPROC>		(gxglewGetProcAddress("glCompileShader"));
	glUseProgram		= reinterpret_cast<PFNGLUSEPROGRAMPROC>			(gxglewGetProcAddress("glGetShaderiv"));
	glLinkProgram		= reinterpret_cast<PFNGLLINKPROGRAMPROC>		(gxglewGetProcAddress("glGetShaderInfo"));
	glGetProgramiv		= reinterpret_cast<PFNGLGETPROGRAMIVPROC>		(gxglewGetProcAddress("glGetShaderiv"));
	glGetProgramInfoLog	= reinterpret_cast<PFNGLGETPROGRAMINFOLOGPROC>	(gxglewGetProcAddress("glGetShaderInfo"));

	return true;
#else
	return false;
#endif
}

/**********************************************************************//**
 *
 * glext̎w@\pł邩ǂ
 * 
 -----------------------------------------------------------------------
 * @param [in]	pFunction	= @\
 * @return	^Ul
*//***********************************************************************/
bool gxglewGetExtension(LPCSTR pFunction)
{
#ifdef _IRIS_SUPPORT_GLEW
	return glewGetExtension(pFunction) != 0;
#else
	LPCSTR ext = reinterpret_cast<LPCSTR>(glGetString(GL_EXTENSIONS));
	if( strstr(ext, pFunction) == nullptr ) return false;
	return true;
#endif
}

/**********************************************************************//**
 *
 * glew̃G[o
 * 
 -----------------------------------------------------------------------
 * @param [in]	Error	= G[l
 * @return	
*//***********************************************************************/
LPCSTR gxglewGetErrorString(GLenum Error)
{
#ifdef _IRIS_SUPPORT_GLEW
	return reinterpret_cast<LPCSTR>(glewGetErrorString(Error));
#else
	return nullptr;
#endif
}

/**********************************************************************//**
 *
 * glew̕擾
 * 
 -----------------------------------------------------------------------
 * @param [in]	Name	= 擾̔ԍ
 * @return	
*//***********************************************************************/
LPCSTR gxglewGetString(GLenum Name)
{
#ifdef _IRIS_SUPPORT_GLEW
	return reinterpret_cast<LPCSTR>(glewGetString(Name));
#else
	return reinterpret_cast<LPCSTR>(glGetString(Name));
#endif
}

/**********************************************************************//**
 *
 * glext֐|C^̎擾
 * 
 -----------------------------------------------------------------------
 * @param [in]	pFunction	= @\
 * @return	֐|C^
*//***********************************************************************/
PROC gxglewGetProcAddress(LPCSTR pFunction)
{
#if		defined(_WIN32)
	return wglGetProcAddress(pFunction);
#else
	return nullptr;
#endif
}

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#ifndef _IRIS_SUPPORT_GLEW
//======================================================================
// variable

#endif

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../ut/GXGLUT.h"
#include "../../../iris_using.h"
#include "../../../iris_global.h"

//======================================================================
// test
IRIS_UNITTEST(CGXGLEWUnitTest,GXGLEWUnitTest)
{
	int argc = irisGetArgc();
	gxglutInit(&argc, irisGetArgv());
    gxglutInitDisplayMode( GXGLUT_RGBA | GXGLUT_DOUBLE );
	gxglutInitWindowPosition(100, 100);
	gxglutInitWindowSize( 256, 256 );
    int win = gxglutCreateWindow( "GXGLEWUnitTest" );
	if( !gxglewInit() ) return;
	glBlendEquationEXT(0);
	gxglutDestroyWindow(win);
}

#endif

#endif
