//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLTexture.cpp
 * @brief		gl Texture NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_GXGLTexture_CPP_

//======================================================================
// include
#include "GXGLTexture.h"
#include "GXGLFVF.h"

#if	defined(_IRIS_SUPPORT_OPENGL)

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CGLTexture::CGLTexture(void)
: m_TextureID(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CGLTexture::~CGLTexture(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 쐬
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CGLTexture::Create(void)
{
	glGenTextures(1, &m_TextureID);
	if( m_TextureID == 0 ) 
	{
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
void CGLTexture::Release(void)
{
	if( m_TextureID != 0 ) 
	{
		glDeleteTextures(1, &m_TextureID);
		m_TextureID = 0;
	}
}

/**********************************************************************//**
 *
 * ֘At
 * 
*//***********************************************************************/
void CGLTexture::Bind(void)
{
	glBindTexture(GL_TEXTURE_2D, m_TextureID);
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void CGLTexture::Draw2D(void)
{
	Bind();
	typedef CGLFVF<GXGL_TEXTURE_FLOAT|GXGL_VERTEX_FLOAT|GXGL_VERTEX_XY|GXGL_TRANSFORM_2D> fvf;	
	fvf* vtx = (fvf*)(gxglGetMemory(fvf::SIZE * 4));
	vtx[0].u() = 0.0f;
	vtx[0].v() = 0.0f;
	vtx[0].x() = 0.0f;
	vtx[0].y() = 0.0f;

	vtx[1].u() = 0.0f;
	vtx[1].v() = 1.0f;
	vtx[1].x() = 0.0f;
	vtx[1].y() = (GLfloat)m_Height;

	vtx[2].u() = 1.0f;
	vtx[2].v() = 0.0f;
	vtx[2].x() = (GLfloat)m_Width;
	vtx[2].y() = 0.0f;

	vtx[3].u() = 1.0f;
	vtx[3].v() = 1.0f;
	vtx[3].x() = (GLfloat)m_Width;
	vtx[3].y() = (GLfloat)m_Height;

	gxglDrawArray(GL_TRIANGLE_STRIP, fvf::FVF, 4, nullptr, vtx);
}

/**********************************************************************//**
 *
 * C[W̊蓖
 * 
 ----------------------------------------------------------------------
 * @param [in]	level			= ~bv}bvx
 * @param [in]	internalFormat	= 
 * @param [in]	width			= 
 * @param [in]	height			= 
 * @param [in]	border			= ItZbg
 * @param [in]	format			= tH[}bg
 * @param [in]	type			= ^Cv
 * @param [in]	pixels			= sNZf[^
*//***********************************************************************/
void CGLTexture::Image2D(GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border
						 , GLenum format, GLenum type, const GLvoid* pixels)
{
	m_Width = width;
	m_Height = height;
	glTexImage2D(GL_TEXTURE_2D, level, internalFormat, width, height, border, format, type, pixels);
}

/**********************************************************************//**
 *
 * C[W̊蓖
 * 
 ----------------------------------------------------------------------
 * @param [in]	level		= ~bv}bvx
 * @param [in]	xoffset		= xItZbg
 * @param [in]	yoffset		= yItZbg
 * @param [in]	width		= 
 * @param [in]	height		= 
 * @param [in]	format		= tH[}bg
 * @param [in]	type		= ^Cv
 * @param [in]	pixels		= sNZf[^
*//***********************************************************************/
void CGLTexture::SubImage2D(GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height
						 , GLenum format, GLenum type, const GLvoid* pixels)
{
	glTexSubImage2D(GL_TEXTURE_2D, level, xoffset, yoffset, width, height, format, type, pixels);
}

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif
