//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLSystem.h
 * @brief		gl NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGLSystem_H_
#define INCG_IRIS_GXGLSystem_H_

//======================================================================
// include
#include "../../fnd/container/FndSingleton.h"
#include "GXGL.h"
#include "ut/GXGLUT.h"

#if	defined(_IRIS_SUPPORT_OPENGL)

//======================================================================
// function

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// class
/// OpenGL NX
class COpenGL : public fnd::CSingleton<COpenGL>
{
public:
	/// p\
	typedef struct INIT_PARAM
	{
		GLint		x;		//!< position
		GLint		y;		//!< position
		GLsizei		width;	//!< 
		GLsizei		height;	//!< 

		// RXgN^
		INIT_PARAM(void) : x(0), y(0), width(640), height(480) {}
	} INIT_PARAM, *LPINIT_PARAM;

protected:
	void*	m_pDisplayList;
	u32		m_Size;
#ifdef INCG_IRIS_GXGLSystem_CPP_
public:
#else
private:
#endif
	// RXgN^
	COpenGL(void);
	// fXgN^
	~COpenGL(void);

public:
	// 
	virtual bool	Initialize(LPINIT_PARAM param);
	// DisplayListobt@̐ݒ
	virtual void	SetDisplayListBuffer(void* pList, u32 size);
	// 擾
	virtual void*	GetMemory(int nSize);

	// Jn
	virtual void	Start(void);
	// I
	virtual int		Finish(void);
	// SwapBuffers
	virtual void	SwapBuffers(void);
	// Viewport
	virtual void	Viewport(int x, int y, int width, int height);

public:
	void	DrawArray(int nPrim, int nVtype, int nCount, const void* pIndices, const void* pVertices)
			{ gxglDrawArray(nPrim, nVtype, nCount, pIndices, pVertices); }
	void	DrawArrayN(int nPrim, int nVtype, int nCount, int nPrimCount, const void* pIndices, const void* pVertices)
			{ gxglDrawArrayN(nPrim, nVtype, nCount, nPrimCount, pIndices, pVertices); }
public:
	/// NA
	static	void	Clear(GLbitfield mask)		{ glClear(mask); }
	/// NAJ[
	static	void	ClearColor(IrisUInt color)	{ gxglClearColor(color); }
	/// NAJ[
	static	void	ClearColor(GLclampf r, GLclampf g, GLclampf b, GLclampf a)	{ glClearColor(r, g, b, a); }
	/// begin
	static	void	Begin(GLenum mode)			{ glBegin(mode); }
	/// end
	static	void	End(void)					{ glEnd(); }
	/// enable
	static	void	Enable(GLenum cap)			{ glEnable(cap); }
	/// disable
	static	void	Disable(GLenum cap)			{ glDisable(cap); }

	/// }gbNX̑ޔ
	static	void	PushMatrix(void)			{ glPushMatrix(); }
	/// }gbNX̕A
	static	void	PopMatrix(void)				{ glPopMatrix(); }
	/// sړ
	static	void	Translatef(GLfloat x, GLfloat y, GLfloat z)		{ glTranslatef(x, y, z); }
	static	void	Translated(GLdouble x, GLdouble y, GLdouble z)	{ glTranslated(x, y, z); }
	/// ]
	static	void	Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)		{ glRotatef(angle, x, y, z); }
	static	void	Rotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z)	{ glRotated(angle, x, y, z); }

	/// uhݒ
	static	void	BlendFunc(GLenum sfactor, GLenum dfactor)	{ glBlendFunc(sfactor, dfactor); }

	/// G[l擾
	static	GLenum	GetError(void)				{ return glGetError(); }
};

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
