//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLError.h
 * @brief		gl G[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGLError_H_
#define INCG_IRIS_GXGLError_H_

//======================================================================
// include
#include "gxgl_inchead.h"

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// function
// Error code ̎擾
LPCTSTR		gxglGetErrorString (GLenum Error);
LPCSTR		gxglGetErrorStringA(GLenum Error);
LPCWSTR		gxglGetErrorStringW(GLenum Error);

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

//======================================================================
// define
#define GXGL_SUCCEEDED(result)			(result == GL_NO_ERROR)
#define GXGL_FAILED(result)				(result != GL_NO_ERROR)

#ifdef _IRIS_DEBUG

#define GXGL_ERROR(Error)				do { if( GXGL_FAILED(Error) ) { dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) :<%s>.\n")  , __LINE__, ::iris::gx::gl::gxglGetErrorString(Error)); } } while(0)
#define GXGL_ERROR2(Error, comm)		do { if( GXGL_FAILED(Error) ) { dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s:<%s>.\n"), __LINE__, comm, ::iris::gx::gl::gxglGetErrorString(Error)); } } while(0)
#define GXGL_CHECK_RESULT(exp)			do { GLenum Error = (exp); if( GXGL_FAILED(Error) ) {				\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n")		\
													, __LINE__, TEXT(#exp), ::iris::gx::gl::gxglGetErrorString(Error)); \
										} } while(0)
#define GXGL_DO_CHECK_RESULT(exp, todo)	do { GLenum Error = (exp); if( GXGL_FAILED(Error) ) {							\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n")		\
													, __LINE__, TEXT(#exp), ::iris::gx::gl::gxglGetErrorString(Error)); \
											todo;																		\
										} } while(0)

#else

#define GXGL_ERROR(Error)				(void)(0)
#define GXGL_ERROR2(Error,comm)			(void)(0)
#define GXGL_CHECK_RESULT(exp)			exp
#define GXGL_DO_CHECK_RESULT(exp, todo)	do { if( GXGL_FAILED(exp) ) { todo; } } while(0)

#endif


#endif
