//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLError.cpp
 * @brief		gl G[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_GXGLError_CPP_

//======================================================================
// include
#include "GXGLError.h"


namespace iris {
namespace gx {
namespace gl
{

/**********************************************************************//**
 *
 * error code ̎擾
 * 
 ----------------------------------------------------------------------
 * @param [in]	error	= G[R[h
 * @return	G[R[h
*//***********************************************************************/
LPCTSTR gxglGetErrorString (GLenum Error)
{
#ifdef UNICODE
	return gxglGetErrorStringW(Error);
#else
	return gxglGetErrorStringA(Error);
#endif
}
/// gxglGetErrorString Q
LPCSTR gxglGetErrorStringA(GLenum Error)
{
#if	defined(_IRIS_SUPPORT_OPENGL)
	switch( Error )
	{
	case GL_NO_ERROR:			{ static const char err_msg[] = "GL_NO_ERROR";			return err_msg; } break;
	case GL_INVALID_ENUM:		{ static const char err_msg[] = "GL_INVALID_ENUM";		return err_msg; } break;
	case GL_INVALID_VALUE:		{ static const char err_msg[] = "GL_INVALID_VALUE";		return err_msg; } break;
	case GL_INVALID_OPERATION:	{ static const char err_msg[] = "GL_INVALID_OPERATION"; return err_msg; } break;
	case GL_STACK_OVERFLOW:		{ static const char err_msg[] = "GL_STACK_OVERFLOW";	return err_msg; } break;
	case GL_STACK_UNDERFLOW:	{ static const char err_msg[] = "GL_STACK_UNDERFLOW";	return err_msg; } break;
	case GL_OUT_OF_MEMORY:		{ static const char err_msg[] = "GL_OUT_OF_MEMORY";		return err_msg; } break;
	}
#else
	IRIS_UNUSED_VARIABLE(Error);
#endif
	return nullptr;
}
/// gxglGetErrorString Q
LPCWSTR gxglGetErrorStringW(GLenum Error)
{
#if	defined(_IRIS_SUPPORT_OPENGL)
	switch( Error )
	{
	case GL_NO_ERROR:			{ static const WCHAR err_msg[] = L"GL_NO_ERROR";			return err_msg; } break;
	case GL_INVALID_ENUM:		{ static const WCHAR err_msg[] = L"GL_INVALID_ENUM";		return err_msg; } break;
	case GL_INVALID_VALUE:		{ static const WCHAR err_msg[] = L"GL_INVALID_VALUE";		return err_msg; } break;
	case GL_INVALID_OPERATION:	{ static const WCHAR err_msg[] = L"GL_INVALID_OPERATION";	return err_msg; } break;
	case GL_STACK_OVERFLOW:		{ static const WCHAR err_msg[] = L"GL_STACK_OVERFLOW";		return err_msg; } break;
	case GL_STACK_UNDERFLOW:	{ static const WCHAR err_msg[] = L"GL_STACK_UNDERFLOW";		return err_msg; } break;
	case GL_OUT_OF_MEMORY:		{ static const WCHAR err_msg[] = L"GL_OUT_OF_MEMORY";		return err_msg; } break;
	}
#else
	IRIS_UNUSED_VARIABLE(Error);
#endif
	return nullptr;
}

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

