//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXCamera.h
 * @brief		FBX SDK cameraNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXCamera_H_
#define INCG_IRIS_FBXCamera_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "../../../fnd/types/FndExecutor.h"
#include "../FBXAttribute.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/// FBX SDK Camera
class CFBXCamera : public IFBXAttribute<KFbxCamera>, public fnd::CExecutor
{
	typedef IFBXAttribute<KFbxCamera>	_Mybase;
protected:
	KTime	m_Time;	//!< 
public:
	// RXgN^
	CFBXCamera(void);
	// RXgN^
	CFBXCamera(kfbx_ptr ptr);
	// RXgN^
	CFBXCamera(CFBXCamera& obj);
	// fXgN^
	virtual ~CFBXCamera(void);

public:
	// XV
	virtual	void	Update(xf32 time);
	// `
	virtual	void	Draw(void);

public:
	// ˉes̎擾
	IrisFMtx44*	GetPerspectiveFov(IrisFMtx44* rMatrix);
	// r[s̎擾
	IrisFMtx44*	GetViewMatrix(IrisFMtx44* rMatrix);
	// p̎擾
	f32		GetFovy(void);
};


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
