//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXScene.cpp
 * @brief		FBX SDK sceneNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FBXScene_CPP_

//======================================================================
// include
#include "FBXScene.h"

#ifdef _IRIS_SUPPORT_FBX
#include "FBXNode.h"
#include "model/FBXMesh.h"
#include "scene/FBXGlobalCamera.h"
#include "model/FBXSkeleton.h"
#include "fbxsdkver.h"
#include "../../iris_debug.h"

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CFBXScene::CFBXScene(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CFBXScene::~CFBXScene(void)
{
}

/**********************************************************************//**
 *
 * XV
 * 
 ----------------------------------------------------------------------
 * @param [in]	time	= XVb
*//***********************************************************************/
void CFBXScene::Update(xf32 time)
{
	KFbxNode* pRootNode = m_pKfbx->GetRootNode();
	Update(pRootNode, time);
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void CFBXScene::Draw(void)
{
	KFbxNode* pRootNode = m_pKfbx->GetRootNode();
	CFBXGlobalCamera gcamera(*this);
	gcamera.Draw();
	Draw(pRootNode);
}

/**********************************************************************//**
 *
 * XV
 * 
 ----------------------------------------------------------------------
 * @param [in]	pNode	= Jgm[h
 * @param [in]	time	= XVb
*//***********************************************************************/
void CFBXScene::Update(KFbxNode* pNode, xf32 time)
{
	KFbxNodeAttribute *pAttr = pNode->GetNodeAttribute();
	if( pAttr != nullptr )
	{
		KFbxNodeAttribute::EAttributeType type = pAttr->GetAttributeType();
		switch(type)
		{
		case KFbxNodeAttribute::eMARKER:
			break;
		case KFbxNodeAttribute::eSKELETON:
			break;
		case KFbxNodeAttribute::eMESH:
			break;
		case KFbxNodeAttribute::eNURB:
			break;
		case KFbxNodeAttribute::ePATCH:
			break;
		case KFbxNodeAttribute::eCAMERA:
			break;
#if FBXSDK_AT_LEAST(FBXSDK_VER_201102)
		case KFbxNodeAttribute::eCAMERA_STEREO:
			break;
#endif
		case KFbxNodeAttribute::eCAMERA_SWITCHER:
			break;
		case KFbxNodeAttribute::eLIGHT:
			break;
		}
	}

	int childNodeNum = pNode->GetChildCount();
	for( int i=0; i < childNodeNum; ++i )
	{
		Update(pNode->GetChild(i), time);	
	}
}

/**********************************************************************//**
 *
 * `
 * 
 ----------------------------------------------------------------------
 * @param [in]	pNode	= Jgm[h
*//***********************************************************************/
void CFBXScene::Draw(KFbxNode* pNode)
{
	KFbxNodeAttribute *pAttr = pNode->GetNodeAttribute();
	if( pAttr != nullptr )
	{
		KFbxNodeAttribute::EAttributeType type = pAttr->GetAttributeType();
		switch(type)
		{
		case KFbxNodeAttribute::eMARKER:
			break;
		case KFbxNodeAttribute::eSKELETON:
			{
				CFBXSkeleton skeleton(static_cast<KFbxSkeleton*>(pAttr));
				skeleton.Draw();
			}
			break;
		case KFbxNodeAttribute::eMESH:
			{
				CFBXMesh mesh(static_cast<KFbxMesh*>(pAttr));
				mesh.Draw();
			}
			break;
		case KFbxNodeAttribute::eNURB:
			break;
		case KFbxNodeAttribute::ePATCH:
			break;
		case KFbxNodeAttribute::eCAMERA:
			{
				CFBXCamera camera(pNode->GetCamera());
				camera.Draw();
			}
			break;
#if FBXSDK_AT_LEAST(FBXSDK_VER_201102)
		case KFbxNodeAttribute::eCAMERA_STEREO:
			break;
#endif
		case KFbxNodeAttribute::eCAMERA_SWITCHER:
			break;
		case KFbxNodeAttribute::eLIGHT:
			break;
		}
	}

	int childNodeNum = pNode->GetChildCount();
	for( int i=0; i < childNodeNum; ++i )
	{
		Draw(pNode->GetChild(i));	
	}
}


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif
