//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXObserver.h
 * @brief		FBX observerNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXObserver_H_
#define INCG_IRIS_FBXObserver_H_

//======================================================================
// include
#include "../../fnd/container/FndObserver.h"

#ifdef _IRIS_SUPPORT_FBX
#include "fbx_inchead.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// delare
class CFBXManager;
class IFBXObjectObserver;

//======================================================================
// class
/// FBX֘AIuWFNgǗNX
class CFBXSubject : public fnd::CSubject<IFBXObjectObserver>
{
	CFBXManager*	m_pMngr;	//!< Ǘ҃NX
public:
	/// RXgN^
	CFBXSubject(CFBXManager* pMngr) : m_pMngr(pMngr) {}
	// fXgN^
	~CFBXSubject(void);
public:
	/// ManagerNX̎擾
	CFBXManager*	GetManager(void)	{ return m_pMngr; }
};

/// FBX SDK IuWFNgIuU[o[
class IFBXObjectObserver : public fnd::CObserver<IFBXObjectObserver>
{
public:
	/// RXgN^
	IFBXObjectObserver(void)	{}
	/// fXgN^
	virtual ~IFBXObjectObserver(void) { Release(); }

public:
	/// 
	virtual void	Release(void)	{}
	/// }lW[NX̎擾
	CFBXManager*	GetManager(void)
	{
		CFBXSubject* pSubject = static_cast<CFBXSubject*>(GetSubject());
		if( pSubject == nullptr ) return nullptr;
		return pSubject->GetManager();
	}
};

/// fXgN^
inline CFBXSubject::~CFBXSubject(void)
{
	value_ptr curr = m_pObservers;
	while(curr != nullptr)
	{
		curr->Release();
		curr = curr->GetNext();
	}
}

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
