//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXObject.h
 * @brief		FBX SDK IuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXObject_H_
#define INCG_IRIS_FBXObject_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "FBXObserver.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/// FBX SDK IuWFNgC^[tFCX
template<class _Kfbx>
class IFBXObjectBase : public IIrisObject
{
	typedef IFBXObjectBase<_Kfbx>	_Myt;
public:
	typedef _Kfbx	kfbx_type;
	typedef _Kfbx*	kfbx_ptr;
	typedef _Kfbx&	kfbx_ref;
protected:
	kfbx_ptr	m_pKfbx;	//!< FBX Object
public:
	/// RXgN^
	IFBXObjectBase(void) : m_pKfbx(nullptr)	{}
	/// RXgN^
	IFBXObjectBase(kfbx_ptr ptr) : m_pKfbx(ptr)	{}
	/// RXgN^
	IFBXObjectBase(_Myt& obj) : m_pKfbx(obj.m_pKfbx)	{}
	/// fXgN^
	~IFBXObjectBase(void)	{}

	// operator
	/// kFbxIuWFNg̎擾
	kfbx_ptr	operator () (void)			{ return GetFBXObject(); }
	/// kFbxIuWFNgւ̃LXg
	operator	kfbx_ptr (void)				{ return GetFBXObject(); }
	/// A[ZqkFbxIuWFNgɃANZX
	kfbx_ptr	operator -> (void)			{ return GetFBXObject(); }

public:
	/// LȃAhXĂ邩ǂ
	bool		IsValid(void)		{ return (m_pKfbx != nullptr); }
	/// KFbxIuWFNg̎擾
	kfbx_ptr	GetFBXObject(void)	{ return m_pKfbx; }
};

/// FBX SDK IuWFNgC^[tFCX
template<class _Kfbx>
class CFBXObject : public IFBXObjectBase<_Kfbx>, public IFBXObjectObserver
{
	friend class CFBXManager;	//!< @ref CFBXManager
public:
	/// RXgN^
	CFBXObject(void) {}
	/// fXgN^
	virtual ~CFBXObject(void)
	{
		Release();
	}
public:
	/// 
	virtual void Release(void)
	{
		if( m_pKfbx == nullptr ) return;
		m_pKfbx->Destroy();
		m_pKfbx = nullptr;
	}

public:
	template<class _Other>struct rebind 
	{
		typedef CFBXObject<_Other>	other;
	};
};

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
