//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXNode.cpp
 * @brief		FBX SDK nodeNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FBXNode_CPP_

//======================================================================
// include
#include "FBXNode.h"

#ifdef _IRIS_SUPPORT_FBX
#include "FBXPose.h"
#include "fbxsdkver.h"
#include "../../iris_debug.h"

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * [hW̎擾
 * 
 ----------------------------------------------------------------------
 * @param [in]	pNode	= 擾m[h
 * @param [in]	rTime	= 
 * @param [in]	pParent	= ẽ[hW
 * @return }gbNX
*//***********************************************************************/
KFbxXMatrix GetGlobalPosition(KFbxNode* pNode, KTime& rTime, KFbxXMatrix* pParent)
{
	IRIS_ASSERT(pNode != nullptr);
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201102)
	return pNode->GetScene()->GetEvaluator()->GetNodeGlobalTransform(pNode, rTime);
#else
	return pNode->GetGlobalFromCurrentTake(rTime);
#endif
}

/**********************************************************************//**
 *
 * [hW̎擾
 * 
 ----------------------------------------------------------------------
 * @param [in]	pNode	= 擾m[h
 * @param [in]	rTime	= 
 * @param [in]	pPose	= |[Y
 * @param [in]	pParent	= ẽ[hW
 * @return }gbNX
*//***********************************************************************/
KFbxXMatrix GetGlobalPosition(KFbxNode* pNode, KTime& rTime, KFbxPose* pPose, KFbxXMatrix* pParent)
{
	IRIS_ASSERT(pNode != nullptr);
	if( pPose != nullptr )
	{
		int NodeIndex = pPose->Find(pNode);
		if( NodeIndex >= 0 )
		{
			if( pPose->IsBindPose() || pPose->IsLocalMatrix(NodeIndex) )
			{
				return GetPoseMatrix(pPose, NodeIndex);
			}

			KFbxXMatrix xmtx;
			if( pParent == nullptr )
			{
				pParent = &xmtx;
				if( pNode->GetParent() != nullptr )
				{
					xmtx = GetGlobalPosition(pNode->GetParent(), rTime, pPose);
				}
			}
			KFbxXMatrix LocalMatrix = GetPoseMatrix(pPose, NodeIndex);
			xmtx = LocalMatrix * (*pParent);
			return xmtx;
		}
	}
	return GetGlobalPosition(pNode, rTime, pParent);
}

/**********************************************************************//**
 *
 * WIg}gbNX̎擾
 * 
 ----------------------------------------------------------------------
 * @param [in]	pNode	= 擾m[h
 * @return }gbNX
*//***********************************************************************/
KFbxXMatrix GetGeometricMatrix(KFbxNode* pNode)
{
	IRIS_ASSERT(pNode != nullptr);
	KFbxXMatrix xmtx;
	xmtx.SetT( pNode->GetGeometricTranslation(KFbxNode::eSOURCE_SET) );
	xmtx.SetR( pNode->GetGeometricRotation(KFbxNode::eSOURCE_SET) );
	xmtx.SetS( pNode->GetGeometricScaling(KFbxNode::eSOURCE_SET) );
	return xmtx;
}


//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CFBXNode::CFBXNode(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 * 
 ----------------------------------------------------------------------
 * @param [in] ptr	= FBXm[hNX|C^
*//***********************************************************************/
CFBXNode::CFBXNode(kfbx_ptr ptr)
: IFBXObjectBase<KFbxNode>(ptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 * 
 ----------------------------------------------------------------------
 * @param [in] ptr	= FBXm[hNX
*//***********************************************************************/
CFBXNode::CFBXNode(CFBXNode& obj)
: IFBXObjectBase<KFbxNode>(obj)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CFBXNode::~CFBXNode(void)
{
}

/**********************************************************************//**
 *
 * m[hAgr[ǧ
 * 
 ----------------------------------------------------------------------
 * @param [in] Type	= Agr[g^Cv
 * @return m[hAgr[gAhX
*//***********************************************************************/
KFbxNodeAttribute* CFBXNode::FindAttribute(KFbxNodeAttribute::EAttributeType Type)
{
	KFbxNodeAttribute* pAttr = m_pKfbx->GetNodeAttribute();
	if( pAttr != nullptr && pAttr->GetAttributeType() == Type ) return pAttr;
	return FindChildAttribute(m_pKfbx, Type);
}

/**********************************************************************//**
 *
 * m[hAgr[ǧ
 * 
 ----------------------------------------------------------------------
 * @param [in] pPrevAttr	= JnAgr[g
 * @param [in] Type			= Agr[g^Cv
 * @return m[hAgr[gAhX
*//***********************************************************************/
KFbxNodeAttribute* CFBXNode::FindAttribute(KFbxNodeAttribute* pPrevAttr
										   , KFbxNodeAttribute::EAttributeType Type)
{
	IRIS_ASSERT(pPrevAttr != nullptr);
	int i=0;		
	KFbxNode* pNode = pPrevAttr->GetNode();
	KFbxNodeAttribute* pAttr = nullptr;
	while( 1 )
	{
		pAttr = FindChildAttribute(pNode, Type);
		if( pAttr != nullptr ) return pAttr;

		// ̌m[h
		while( 1 )
		{
			KFbxNode* pParent = pNode->GetParent();
			// ZT
			int num = pParent->GetChildCount();
			for( i=0; i < num; ++i )
			{
				if( pParent->GetChild(i) == pNode ) break;
			}
			if( i < num ) 
			{
				pNode = pParent->GetChild(i);
				break;
			}
			// ěZT
			pNode = pParent;
			if( pParent == m_pKfbx ) return nullptr;
		}
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * qm[h̃m[hAgr[ǧ
 * 
 ----------------------------------------------------------------------
 * @param [in] pCurrent	= Jnm[h
 * @param [in] Type		= Agr[g^Cv
 * @return m[hAgr[gAhX
*//***********************************************************************/
KFbxNodeAttribute* CFBXNode::FindChildAttribute(KFbxNode* pCurrent
										   , KFbxNodeAttribute::EAttributeType Type)
{
	KFbxNode* pNode = pCurrent;
	KFbxNodeAttribute* pAttr = nullptr;

	// q
	int num = pNode->GetChildCount();
	for( int i=0; i < num; ++i )
	{
		KFbxNode* pChild = pNode->GetChild(i);
		pAttr = pChild->GetNodeAttribute();
		if( pAttr != nullptr && pAttr->GetAttributeType() == Type ) return pAttr;
		pAttr = FindChildAttribute(pChild, Type);
		if( pAttr != nullptr ) return pAttr;
	}
	return nullptr;
}

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif
