//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXImporter.h
 * @brief		FBX SDK importerNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXImporter_H_
#define INCG_IRIS_FBXImporter_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "FBXObject.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/// FBX SDK Importer
class CFBXImporter : public CFBXObject<KFbxImporter>
{
public:
	// RXgN^
	CFBXImporter(void);
	// fXgN^
	virtual ~CFBXImporter(void);

public:
	// 
	bool	Initialize(LPCSTR pFileName, int iFileFormat=-1);
	// 
	bool	InitializeEx(LPCSTR pFileName);

	// t@Co[W̎擾
	void	GetFileVersion(int& rMajor, int& rMinor, int& rRevision);
	// V[̃C|[g
	bool	Import(CFBXObject<KFbxScene>* pScene);

};


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
