//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXImporter.cpp
 * @brief		FBX SDK importerNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FBXObject_CPP_

//======================================================================
// include
#include "FBXImporter.h"
#include "FBXManager.h"
#include "fbxsdkver.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CFBXImporter::CFBXImporter(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CFBXImporter::~CFBXImporter(void)
{
}

/**********************************************************************//**
 *
 * 
 * 
 ----------------------------------------------------------------------
 * @param [in]	pFileName	= t@C
 * @param [in]	iFileFormat	= t@CtH[}bg
 * return	
*//***********************************************************************/
bool CFBXImporter::Initialize(LPCSTR pFileName, int iFileFormat)
{
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201002)
	return m_pKfbx->Initialize(pFileName, iFileFormat);
#else
#pragma IRIS_WARNING_DISABLE(4996)
	m_pKfbx->SetFileFormat(iFileFormat);
#pragma IRIS_WARNING_DEFAULT(4996)
	return m_pKfbx->Initialize(pFileName);
#endif
}

/**********************************************************************//**
 *
 * 
 * 
 * @note	tH[}bgݒs
 *
 ----------------------------------------------------------------------
 * @param [in]	pFileName	= t@C
 * return	
*//***********************************************************************/
bool CFBXImporter::InitializeEx(LPCSTR pFileName)
{
	int format = -1;
	IRIS_ASSERT( GetManager() != nullptr );
	IRIS_ASSERT( GetManager()->GetIOPluginRegistry() != nullptr );
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201102)
	if( GetManager()->GetIOPluginRegistry()->DetectReaderFileFormat(pFileName, format) )
#else
	if( GetManager()->GetIOPluginRegistry()->DetectFileFormat(pFileName, format) )
#endif
	{
		// s
		format = GetManager()->GetIOPluginRegistry()->GetNativeReaderFormat();
	}
	return Initialize(pFileName, format);
}

/**********************************************************************//**
 *
 * o[W̎擾
 * 
 ----------------------------------------------------------------------
 * @param [out]	rMajor		= W[o[W
 * @param [out]	rMinor		= }Ci[o[W
 * @param [out] rRevision	= rW
*//***********************************************************************/
void CFBXImporter::GetFileVersion(int& rMajor, int& rMinor, int& rRevision)
{
	IRIS_ASSERT( m_pKfbx != nullptr );
	m_pKfbx->GetFileVersion(rMajor, rMinor, rRevision);
}

/**********************************************************************//**
 *
 * V[̃C|[g
 * 
 ----------------------------------------------------------------------
 * @param [in]	pScene	= V[IuWFNg
 * return	
*//***********************************************************************/
bool CFBXImporter::Import(CFBXObject<KFbxScene>* pScene)
{
	IRIS_ASSERT( pScene != nullptr );
	IRIS_ASSERT( pScene->GetFBXObject() != nullptr );
	return m_pKfbx->Import(pScene->GetFBXObject());
}

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif
