//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXXFile.h
 * @brief		xt@CNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXXFile_H_
#define INCG_IRIS_DXXFile_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace dx
{

//======================================================================
// typedef
typedef u16		xofToken;

//======================================================================
// struct
IRIS_PRAGMA_WARNING_BEGIN()
IRIS_PRAGMA_WARNING_DISABLE(4200)

/// xt@Cwb_[
typedef struct tagXFileHeader
{
	u4cc	type;		//!< }WbNio[
	u4cc	version;	//!< o[W
	u4cc	format;		//!< tH[}bg
	u32		float_size;	//!< TCY
} XFileHeader, XFILEHEADER, *LPXFILEHEADER;

// g[NR[h
/// XFILE_TOKEN_NAME R[h
typedef struct tagXFileTokenName
{
	xofToken	token;		//!< g[NiXFILE_TOKEN_NAMEj
	u32			count;		//!< name 
	c8			name[0];	//!< 
} XFileTokenName, XFILETOKENNAME, *LPXFILETOKENNAME;

/// XFILE_TOKEN_STRING R[h
typedef struct tagXFileTokenString
{
	xofToken	token;		//!< g[NiXFILE_TOKEN_STRINGj
	u32			count;		//!< string 
	c8			string[0];	//!< 
	// u32		terminator;	// TOKEN_SEMICOLON ܂ TOKEN_COMMA
} XFileTokenString, XFILETOKENSTRING, *LPXFILETOKENSTRING;
/// XFILE_TOKEN_INTEGER R[h
typedef struct tagXFileTokenInteger
{
	xofToken	token;		//!< g[NiXFILE_TOKEN_INTEGERj
	u32			value;		//!< l
} XFileTokenInteger, XFILETOKENINTEGER, *LPXFILETOKENINTEGER;
/// XFILE_TOKEN_GUID R[h
typedef struct tagXFileTokenGUID
{
	xofToken	token;		//!< g[N(XFILE_TOKEN_GUID)
	u32			data1;		//!< 
	u16			data2;		//!< 
	u16			data3;		//!< 
	u8			data4[8];	//!< 
} XFileTokenGUID, XFILETOKENGUID, *LPXFILETOKENGUID;
/// XFILE_TOKEN_INTEGER_LIST
typedef struct tagXFileTokenIntegerList
{
	xofToken	token;		//!< g[N(XFILE_TOKEN_INTEGER_LIST)
	u32			count;		//!< JEg
	u32			list[0];	//!< JEg
} XFileTokenIntegerList, XFILETOKENINTEGERLIST, *LPXFILETOKENINTEGERLIST;
/// XFILE_TOKEN_FLOAT_LIST
typedef struct tagXFileTokenFloatList
{
	xofToken	token;		//!< g[N(XFILE_TOKEN_FLOAT_LIST)
	u32			count;		//!< JEg
	f32			list[0];	//!< float/double Xg
} XFileTokenFloatList, XFILETOKENFLOATLIST, *LPXFILETOKENFLOATLIST;

IRIS_PRAGMA_WARNING_END()

//======================================================================
// define
#define XFILE_FMT_MAGIC			IRIS_FOURCC('x', 'o', 'f', ' ')
#define XFILE_FMT_VERSION		IRIS_FOURCC('0', '3', '0', '2')
#define XFILE_FMT_BINARY		IRIS_FOURCC('b', 'i', 'n', ' ')
#define XFILE_FMT_TEXT			IRIS_FOURCC('t', 'x', 't', ' ')
#define XFILE_FMT_COMPRESSED	IRIS_FOURCC('c', 'm', 'p', ' ')
#define XFILE_FMT_FLOATBIT32	IRIS_FOURCC('0', '0', '3', '2')
#define XFILE_FMT_FLOATBIT64	IRIS_FOURCC('0', '0', '6', '4')

// R[hg[N(gGfBAWORD)
#define XFILE_TOKEN_NAME			1
#define XFILE_TOKEN_STRING			2
#define XFILE_TOKEN_INTEGER			3
#define XFILE_TOKEN_GUID			4
#define XFILE_TOKEN_INTEGER_LIST	5
#define XFILE_TOKEN_FLOAT_LIST		6

// X^hAg[N(gGfBAWORD)
#define XFILE_TOKEN_OBRACE			10
#define XFILE_TOKEN_CBRACE			11
#define XFILE_TOKEN_OPAREN			12
#define XFILE_TOKEN_CPAREN			13
#define XFILE_TOKEN_OBRACKET		14
#define XFILE_TOKEN_CBRACKET		15
#define XFILE_TOKEN_OANGLE			16
#define XFILE_TOKEN_CANGLE			17
#define XFILE_TOKEN_DOT				18
#define XFILE_TOKEN_COMMA			19
#define XFILE_TOKEN_SEMICOLON		20
#define XFILE_TOKEN_TEMPLATE		31
#define XFILE_TOKEN_WORD			40
#define XFILE_TOKEN_DWORD			41
#define XFILE_TOKEN_FLOAT			42
#define XFILE_TOKEN_DOUBLE			43
#define XFILE_TOKEN_CHAR			44
#define XFILE_TOKEN_UCHAR			45
#define XFILE_TOKEN_SWORD			46
#define XFILE_TOKEN_SDWORD			47
#define XFILE_TOKEN_VOID			48
#define XFILE_TOKEN_LPSTR			49
#define XFILE_TOKEN_UNICODE			50
#define XFILE_TOKEN_CSTRING			51
#define XFILE_TOKEN_ARRAY			52

//======================================================================
// class
/// xt@CtH[}bgNX
class CXFile : public IIrisObject
{
public:
};


}	// end of namespace dx
}	// end of namespace iris

#endif
