//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvImage.h
 * @brief		OpenCV Image t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvImage_H_
#define INCG_IRIS_CvImage_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../cv_inchead.h"

#ifdef _IRIS_SUPPORT_OPENCV
#include <opencv/highgui.h>

namespace iris {
namespace gx {
namespace cv
{

//======================================================================
// class
/**
 * @brief	OpenCV C[WNX
*/
class CCvImage : public IIrisObject
{
protected:
	::cv::Mat	m_Mat;		//!< data
public:
	// RXgN^
	CCvImage(void);
	// fXgN^
	virtual ~CCvImage(void);

public:
	/**
	 * @name operator
	 * @{
	*/
	operator ::cv::Mat&			(void)			{ return m_Mat; }
	operator const ::cv::Mat&	(void)	const	{ return m_Mat; }
	/**
	 * @}
	*/
public:
	// C[W̍쐬
	bool	Create(const CvSize& size, int depth, int channels);
	// C[W̃[h
	bool	Load(LPCSTR lpszPath, int flags=CV_LOAD_IMAGE_COLOR);
	// 
	void	Release(void);

public:
	// J[tH[}bg̕ϊ
	void	TranslateColor(CCvImage& rImage, int code, int dstChannels=0);

private:
	// A^b`
	void	Attach(IplImage* pImage);
};

}	// end of namespace cv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
