//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CgProfile.h
 * @brief		Cg SDK vt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CgProfile_H_
#define INCG_IRIS_CgProfile_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_CG
#include "cg_inchead.h"
#include "../../iris_object.h"

namespace iris {
namespace gx {
namespace cg
{

//======================================================================
// class
/**
 * @brief	Cg vt@CNX
*/
class CCgProfile : public INonCopyable<>
{
private:
	CGprofile	m_Profile;	//!< vt@C
public:
	// RXgN^
	CCgProfile(void);
	// fXgN^
	~CCgProfile(void);

public:
	// vt@C̍쐬
	bool		Create(LPCSTR pProfileString);
	// vt@C̍쐬
	bool		Create(int index);

public:
	// vt@C̎擾
	CGprofile	GetProfile(void)	{ return m_Profile; }
	// vt@CɑΉ̎擾
	LPCSTR		GetString(void)		{ return cgGetProfileString(m_Profile); }
	// T|[gĂ邩ǂ
	CGbool		IsSupported(void)	{ return cgIsProfileSupported(m_Profile); }
	// vpeB̎擾
	CGbool		GetProperty(CGenum query);

public:
	// T|[gĂvt@C擾
	static	int	GetSupportedNum(void)	{ return cgGetNumSupportedProfiles(); }
};

}	// end of namespace cg
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
