//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndVram.h
 * @brief		VRAMNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndVram_H_
#define INCG_IRIS_FndVram_H_

//======================================================================
// include
#include "../container/FndList.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// VRAMNXC^[tFCX
class IVram : public INonCopyable<IVram>
{
protected:
	u32	m_Base;	//!< x[XAhX
	u32	m_Size;	//!< ̈TCY
public:
	// RXgN^
	IVram(void) : m_Base(0), m_Size(0) {}
public:
	/// x[XAhX̎擾
	u32		GetBase(void)	const	{ return m_Base; }
	/// TCY̎擾
	u32		GetSize(void)	const	{ return m_Size; }
	/// LȃubNǂ
	bool	IsValid(void)	const	{ return m_Size != 0; }
#ifndef INCG_IRIS_FndVram_CPP_
protected:
#endif
	/// ݒ
	void	Set(u32 base, u32 size)	{ m_Base = base; m_Size = size; }
};

/// VRAMubN
class CVramBlock : public fnd::CListNodeBase, public IVram
{
public:
	// ubÑNA
	void	Clear(void);	
};

/// VRAMNX
class CVram : public IVram
{
protected:
	typedef fnd::CList<CVramBlock>	CVramList;
protected:
	CVramList	m_List;	//!< ubNXg
public:
	// RXgN^
	CVram(void);
	// fXgN^
	~CVram(void);

public:
	// 
	bool	Initialize(u32 base, u32 size);
	// I
	void	Terminate(void);

public:
	// ubN̊m
	bool	NewBlockAlign(CVramBlock* pBlk, u32 uSize, u32 uAlign);
	bool	NewBlockAlign(CVramBlock* pBlk, u32 uSize, u32 uAlign, u32 uAreaBase, u32 uAreaSize);
	// ubN̊m
	bool	NewBlock(CVramBlock* pBlk, u32 uBase, u32 uSize);
	// ubN̉
	void	ReleaseBlock(CVramBlock* pBlk);
	// ubN̑S
	void	ReleaseAll(void);
};

/// NITROpVRAMNX

}	// end of namespace fnd
}	// end of namespace iris

#endif
