//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRIFF.cpp
 * @brief		RIFFtH[}bgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndRIFF_CPP_

//======================================================================
// include
#include "FndRIFF.h"
#include "../memory/FndMemory.h"
#include "../io/FndFile.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CRIFF::CRIFF(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CRIFF::~CRIFF(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	fname	= t@CpX
 * @return	
*//***********************************************************************/
bool CRIFF::Open (LPCTSTR fname)
{
#ifdef UNICODE
	return OpenW(fname);
#else
	return OpenA(fname);
#endif
}
/// CPHD::Open Q
bool CRIFF::OpenA(LPCSTR  fname)
{
	Close();

	CFile file;
	if( !file.OpenA(fname, FOPEN_READ) ) return false;
	u32 size = (u32)file.GetSize();

	Alloc(size, 0);
	if( !file.Read(m_pBuffer, size) ) return false;

	if( !_Open() ) 
	{
		Close();
		return false;
	}
	return true;
}
/// CPHD::Open Q
bool CRIFF::OpenW(LPCWSTR fname)
{
	Close();

	CFile file;
	if( !file.OpenW(fname, FOPEN_READ) ) return false;
	u32 size = (u32)file.GetSize();

	Alloc(size, 0);
	if( !file.Read(m_pBuffer, size) ) return false;

	if( !_Open() ) 
	{
		Close();
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CRIFF::Close(void)
{
	Dealloc();
}

/**********************************************************************//**
 *
 * LȏԂǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CRIFF::IsValid(void)	const
{
	return ( m_pBuffer != nullptr );
}

/**********************************************************************//**
 *
 * t@CTCY̎擾
 *
 ----------------------------------------------------------------------
 * @return	t@CTCY
*//***********************************************************************/
u32 CRIFF::GetSize(void)	const
{
	if( !IsValid() ) return 0;
	LPRIFF_FILE_CHUNK head = (LPRIFF_FILE_CHUNK)m_pBuffer;
	return static_cast<u32>(head->Size);
}

/**********************************************************************//**
 *
 * tH[^Cv̎擾
 *
 ----------------------------------------------------------------------
 * @return	tH[^Cv
*//***********************************************************************/
u32 CRIFF::GetFormType(void)	const
{
	if( !IsValid() ) return 0;
	LPRIFF_FILE_CHUNK head = (LPRIFF_FILE_CHUNK)m_pBuffer;
	return head->uForm;
}

/**********************************************************************//**
 *
 * LIST`Ň
 *
 ----------------------------------------------------------------------
 * @param [in] chunk	= ̎n_`N(nullptr̂Ƃ́A擪猟)
 * @return	LIST`N
*//***********************************************************************/
LPRIFF_LIST_CHUNK CRIFF::FindListChunk(LPRIFF_LIST_CHUNK chunk)
{
	if( !IsValid() ) return nullptr;
	LPRIFF_FILE_CHUNK head = (LPRIFF_FILE_CHUNK)m_pBuffer;
	u32 size = static_cast<u32>(head->Size);
	u8* end  = (u8*)m_pBuffer + size;
	if( size <= sizeof(RIFF_FILE_CHUNK) ) return nullptr;

	u8* next = chunk == nullptr ? (u8*)(head + 1) : (u8*)chunk + sizeof(RIFF_LIST_CHUNK) + chunk->Size;
	while(next < end)
	{
		if( *(u32*)next == RIFF_ID_LIST_CHUNK )
		{
			LPRIFF_LIST_CHUNK chunk = (LPRIFF_LIST_CHUNK)next;
			return chunk;
		}
		else
		{
			LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)next;
			next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
		}
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * LIST`Ň
 *
 ----------------------------------------------------------------------
 * @param [in]	ListType	= Xg^Cv
 * @return	LIST`N
*//***********************************************************************/
LPRIFF_LIST_CHUNK CRIFF::FindListChunk(u32 ListType)
{
	if( !IsValid() ) return nullptr;
	LPRIFF_FILE_CHUNK head = (LPRIFF_FILE_CHUNK)m_pBuffer;
	u32 size = static_cast<u32>(head->Size);
	u8* end  = (u8*)m_pBuffer + size;
	if( size <= sizeof(RIFF_FILE_CHUNK) ) return nullptr;

	u8* next = (u8*)(head + 1);
	while(next < end)
	{
		if( *(u32*)next == RIFF_ID_LIST_CHUNK )
		{
			LPRIFF_LIST_CHUNK chunk = (LPRIFF_LIST_CHUNK)next;
			if( chunk->uType == ListType )
			{
				return chunk;
			}
			else
			{
				next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
			}
		}
		else
		{
			LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)next;
			next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
		}
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * Tu`Ň
 *
 ----------------------------------------------------------------------
 * @param [in] chunk	= ̎n_`N(nullptr̂Ƃ́A擪猟)
 * @return	Tu`N
*//***********************************************************************/
LPRIFF_CHUNK CRIFF::FindChunk(LPRIFF_CHUNK chunk)
{
	if( !IsValid() ) return nullptr;
	LPRIFF_FILE_CHUNK head = (LPRIFF_FILE_CHUNK)m_pBuffer;
	u32 size = static_cast<u32>(head->Size);
	u8* end  = (u8*)m_pBuffer + size;
	if( size <= sizeof(RIFF_FILE_CHUNK) ) return nullptr;

	u8* next = chunk == nullptr ? (u8*)(head + 1) : (u8*)chunk + sizeof(RIFF_CHUNK) + chunk->Size;
	while(next < end)
	{
		if( *(u32*)next == RIFF_ID_LIST_CHUNK )
		{
			LPRIFF_LIST_CHUNK chunk = (LPRIFF_LIST_CHUNK)next;
			next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
		}
		else
		{
			LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)next;
			return chunk;
		}
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * Tu`Ň
 *
 ----------------------------------------------------------------------
 * @param [in]	ChunkType	= `N^Cv
 * @return	Tu`N
*//***********************************************************************/
LPRIFF_CHUNK CRIFF::FindChunk(u32 ChunkType)
{
	if( !IsValid() ) return nullptr;
	LPRIFF_FILE_CHUNK head = (LPRIFF_FILE_CHUNK)m_pBuffer;
	u32 size = static_cast<u32>(head->Size);
	u8* end  = (u8*)m_pBuffer + size;
	if( size <= sizeof(RIFF_FILE_CHUNK) ) return nullptr;

	u8* next = (u8*)(head + 1);
	while(next < end)
	{
		if( *(u32*)next == RIFF_ID_LIST_CHUNK )
		{
			LPRIFF_LIST_CHUNK chunk = (LPRIFF_LIST_CHUNK)next;
			next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
		}
		else
		{
			LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)next;
			if( chunk->uID == ChunkType )
			{
				return chunk;
			}
			else
			{
				next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
			}
		}
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * LIST`NTu`Ň
 *
 ----------------------------------------------------------------------
 * @param [in]	list	= LIST`N
 * @param [in]	chunk	= ̎n_`N(nullptr̂Ƃ́A擪猟)
 * @return	Tu`N
*//***********************************************************************/
LPRIFF_CHUNK CRIFF::FindChunk(LPRIFF_LIST_CHUNK list, LPRIFF_CHUNK chunk)
{
	if( list == nullptr ) return FindChunk(chunk);
	if( !IsValid() ) return nullptr;
	u8* end  = (u8*)list + sizeof(RIFF_LIST_CHUNK) + list->Size;
	u8* next = chunk == nullptr ? (u8*)list + sizeof(RIFF_LIST_CHUNK) : (u8*)chunk + sizeof(RIFF_CHUNK) + chunk->Size;
	while(next < end)
	{
		if( *(u32*)next == RIFF_ID_LIST_CHUNK )
		{
			return nullptr;
		}
		else
		{
			LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)next;
			return chunk;
		}
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * LIST`NTu`Ň
 *
 ----------------------------------------------------------------------
 * @param [in]	list		= LIST`N
 * @param [in]	ChunkType	= `N^Cv
 * @return	Tu`N
*//***********************************************************************/
LPRIFF_CHUNK CRIFF::FindChunk(LPRIFF_LIST_CHUNK list, u32 ChunkType)
{
	if( list == nullptr ) return FindChunk(ChunkType);
	if( !IsValid() ) return nullptr;
	u8* end  = (u8*)list + sizeof(RIFF_LIST_CHUNK) + list->Size;
	u8* next = (u8*)list + sizeof(RIFF_LIST_CHUNK);
	while(next < end)
	{
		if( *(u32*)next == RIFF_ID_LIST_CHUNK )
		{
			return nullptr;
		}
		else
		{
			LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)next;
			if( chunk->uID == ChunkType )
			{
				return chunk;
			}
			else
			{
				next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
			}
		}
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * ̃`N擾
 *
 ----------------------------------------------------------------------
 * @param [in]	chunk	= ̎n_`N(nullptr̂Ƃ́A擪猟)
 * @return	̃`N
*//***********************************************************************/
LPRIFF_CHUNK_HEADER CRIFF::GetNextChunk(const LPRIFF_CHUNK_HEADER chunk)
{
	if( !IsValid() ) return nullptr;
	LPRIFF_FILE_CHUNK head = (LPRIFF_FILE_CHUNK)m_pBuffer;
	u32 size = static_cast<u32>(head->Size);
	u8* end  = (u8*)m_pBuffer + size;
	if( size <= sizeof(RIFF_FILE_CHUNK) ) return nullptr;

	u8* next = (u8*)(head + 1);
	if( chunk != nullptr )
	{
		next = (u8*)chunk + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
	}
	if( next >= end ) return nullptr;
	return (LPRIFF_CHUNK_HEADER)next;
}

/**********************************************************************//**
 *
 * ʃI[v
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CRIFF::_Open(void)
{
	if( m_pBuffer == nullptr ) return false;
	LPRIFF_FILE_CHUNK head = (LPRIFF_FILE_CHUNK)m_pBuffer;
	if( head->uID != RIFF_ID_FILE_CHUNK ) return false;
	return true;
}

}	// end of namespace fnd
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"
#include <string.h>

//======================================================================
// test
IRIS_UNITTEST(CFndRIFFUnitTest, FndRIFFUnitTest)
{
	CRIFF riff;
	char path[MAX_PATH] = "../../../data/snd/sample.wav";

#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::cin >> path;
#endif

	if( !riff.OpenA(path) )
	{
		std::cout << "t@CI[vɎs܂B" << std::endl;
		goto end;
	}

	{
		std::cout << "RIFF FMT = 0x" << std::hex << riff.GetFormType() << std::dec << std::endl;
		std::cout << "------------------------------" << std::endl;
		char id_str[5];
		id_str[4] = '\0';
		LPRIFF_CHUNK_HEADER head = riff.GetNextChunk(nullptr);
		while(head != nullptr)
		{
			memcpy(id_str, &head->uID, sizeof(head->uID));
			switch( head->uID )
			{
			case RIFF_ID_LIST_CHUNK:
				{
					LPRIFF_LIST_CHUNK chunk = (LPRIFF_LIST_CHUNK)head;
					std::cout << "ID   : " << id_str << std::endl;
					std::cout << "SIZE : " << chunk->Size << std::endl;
					memcpy(id_str, &chunk->uType, sizeof(chunk->uType));
					std::cout << "TYPE : " << id_str << std::endl;
				}
				break;
			case RIFF_ID_FMT_CHUNK:
				{
					if(head->Size == (sizeof(RIFF_FMT_CHUNK) - sizeof(RIFF_CHUNK_HEADER)) )
					{
						LPRIFF_FMT_CHUNK chunk = (LPRIFF_FMT_CHUNK)head;
						std::cout << "ID         : " << id_str << std::endl;
						std::cout << "SIZE       : " << chunk->Size << std::endl;
						std::cout << "Fmt        : 0x" << std::hex << chunk->Fmt << std::dec << std::endl;
						std::cout << "Channels   : " << chunk->Channels << std::endl;
						std::cout << "Samples    : " << chunk->SamplePerSec << std::endl;
						std::cout << "BytePerSec : " << chunk->BytePerSec << std::endl;
						std::cout << "BlockAlign : " << chunk->BlockAlign << std::endl;
						std::cout << "BitsWidth  : " << chunk->BitsWidth << std::endl;
					}
					else
					{
						LPRIFF_FMT_EX_CHUNK chunk = (LPRIFF_FMT_EX_CHUNK)head;
						std::cout << "ID         : " << id_str << std::endl;
						std::cout << "SIZE       : " << chunk->Size << std::endl;
						std::cout << "Fmt        : 0x" << std::hex << chunk->Fmt << std::dec << std::endl;
						std::cout << "Channels   : " << chunk->Channels << std::endl;
						std::cout << "Samples    : " << chunk->SamplePerSec << std::endl;
						std::cout << "BytePerSec : " << chunk->BytePerSec << std::endl;
						std::cout << "BlockAlign : " << chunk->BlockAlign << std::endl;
						std::cout << "BitsWidth  : " << chunk->BitsWidth << std::endl;
						std::cout << "ExtSize    : " << chunk->ExtSize << std::endl;
					}
				}
				break;
			case RIFF_ID_FACT_CHUNK:
				{
					LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)head;
					std::cout << "ID          : " << id_str << std::endl;
					std::cout << "SIZE        : " << chunk->Size << std::endl;
					switch( chunk->Size )
					{
					case 8:
						{
							u32* samples = (u32*)chunk->pData;
							std::cout << "(ALL - ZERO) SAMPLES: " << samples[0] << std::endl;
							std::cout << "ZERO SAMPLES        : " << samples[1] << std::endl;
						}
						break;
					case 4:
						{
							u32 samples = *(u32*)chunk->pData;
							std::cout << "ALL SAMPLES : " << samples << std::endl;
						}
						break;
					case 2:
						{
							u16 samples = *(u16*)chunk->pData;
							std::cout << "ALL SAMPLES : " << samples << std::endl;
						}
						break;
					case 1:
						{
							u8 samples = *(u8*)chunk->pData;
							std::cout << "ALL SAMPLES : " << samples << std::endl;
						}
						break;
					}
				}
				break;
			case RIFF_ID_SMPL_CHUNK:
				{
					LPRIFF_SMPL_CHUNK chunk = (LPRIFF_SMPL_CHUNK)head;
					std::cout << "ID                : " << id_str << std::endl;
					std::cout << "SIZE              : " << chunk->Size << std::endl;
					std::cout << "Manufacturer      : " << chunk->Manufacturer << std::endl;
					std::cout << "Product           : " << chunk->Product << std::endl;
					std::cout << "SamplePeriod      : " << chunk->SamplePeriod << std::endl;
					std::cout << "MIDIUnityNote     : " << chunk->MIDIUnityNote << std::endl;
					std::cout << "MIDIPitchFraction : " << chunk->MIDIPitchFraction << std::endl;
					std::cout << "SMPTEFormat       : " << chunk->SMPTEFormat << std::endl;
					std::cout << "SMPTEOffset       : " << chunk->SMPTEOffset << std::endl;
					std::cout << "SampleLoops       : " << chunk->SampleLoops << std::endl;
					std::cout << "SamplerData       : " << chunk->SamplerData << std::endl;
					for( s32 i=0; i < chunk->SampleLoops; ++i )
					{
						std::cout << "Identifier    : " << chunk->Loops[0].Identifier << std::endl;
						std::cout << "Type          : " << chunk->Loops[0].Type << std::endl;
						std::cout << "Start         : " << chunk->Loops[0].Start << std::endl;
						std::cout << "End           : " << chunk->Loops[0].End << std::endl;
						std::cout << "Fraction      : " << chunk->Loops[0].Fraction << std::endl;
						std::cout << "PlayCount     : " << chunk->Loops[0].PlayCount << std::endl;
					}
				}
				break;
			default:
				{
					LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)head;
					std::cout << "ID   : " << id_str << std::endl;
					std::cout << "SIZE : " << chunk->Size << std::endl;
				}
				break;
			}
			std::cout << "------------------------------" << std::endl;
			head = (LPRIFF_CHUNK_HEADER)riff.GetNextChunk(head);
		}
	}
end:
	return;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
