//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFlag.h
 * @brief		tONXx[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndFlag_H_
#define INCG_IRIS_FndFlag_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CFlag;
class CProtectedFlag;

// NX}N
#define __DECLARE_FLAG_CLASS(name)					__DECLARE_FLAG_CLASSEX(name, name, public, public, public, public)

#define __DECLARE_FLAG_CLASSEX(name, classname, ac_get, ac_bit, ac_set, ac_ope)	\
class C##classname {								\
	typedef C##classname	MyClass;				\
protected:											\
	u32		m_##name;								\
public:												\
	C##classname(void) : m_##name(0) {}				\
	C##classname(u32 flag) : m_##name(flag) {}		\
	~C##classname(void) {}							\
ac_get:												\
	u32		Get##name(void)			const	{ return m_##name; }					\
	bool	Is##name(u32 bit)		const	{ return ((m_##name & bit) != 0); }		\
	bool	IsEqual##name(u32 bit)	const	{ return ((m_##name & bit) == bit); }	\
ac_bit:																				\
	void	Enable##name(u32 bit)	{ m_##name |= bit; }							\
	void	Disable##name(u32 bit)	{ m_##name &= ~bit; }							\
	void	Set##name(u32 bit, bool enable)	{ enable ? Enable##name(bit) : Disable##name(bit); }		\
	void	Enable##name##Mask(u32 mask, u32 value)	{ Disable##name(mask); Enable##name(mask&value); }	\
ac_set:																		\
	void	Set##name(u32 flag)		{ m_##name = flag; }					\
	void	Copy##name(u32 flag)	{ m_##name = flag; }					\
	void	Clear##name(void)		{ m_##name = 0; }						\
ac_ope:																		\
	MyClass&	operator | (const MyClass& rhs)	{ m_##name |= rhs.m_##name; return *this; }	\
	MyClass&	operator & (const MyClass& rhs)	{ m_##name &= rhs.m_##name; return *this; }	\
	MyClass&	operator ^ (const MyClass& rhs)	{ m_##name ^= rhs.m_##name; return *this; }	\
}

//======================================================================
// tONX
//! public flag class "CFlag"
__DECLARE_FLAG_CLASS(Flag);

//! protected flag class "CProtectedFlag"
__DECLARE_FLAG_CLASSEX(Flag, ProtectedFlag, public, protected, protected, protected);

}	// end of namespace fnd
}	// end of namespace iris

#endif
