//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFade.h
 * @brief		tF[hNXC^[tFCX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndFade_H_
#define INCG_IRIS_FndFade_H_

//======================================================================
// include
#include "FndFlag.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
//! tF[hNXC^[tFCX
class IFade : public CFlag
{
public:
	//! tF[h
	typedef enum
	{
		eFADE_NONE = 0,		//!< Ȃ
		eFADE_IN,			//!< tF[hC
		eFADE_OUT,			//!< tF[hAEg
		eFADE_STATE_NUM
	} FADE_STATE;
protected:
	//! ARGB
	xf32	m_fA, m_fR, m_fG, m_fB;
	xf32	m_fAlpha;		//!< ڕWAt@l
	xf32	m_fVariable;	//!< ϓAt@l
public:
	// RXgN^
	IFade(void);
	// fXgN^
	~IFade(void) {}
public:
	// XV
	virtual void		Update(xf32 time);
	// `
	//virtual void		Draw(void);

public:
	// tF[hC
	virtual void		FadeInT(xf32 alpha, xf32 time);		// Ԏw
	virtual void		FadeInV(xf32 alpha, xf32 variable);	// ϓlw
	// tF[hAEg
	virtual void		FadeOutT(xf32 alpha, xf32 time);		// Ԏw
	virtual void		FadeOutV(xf32 alpha, xf32 variable);	// ϓlw

public:
	// J[ݒ
	/// tF[hJ[o̓J[ɔf
	virtual void		ChangeFadeColor(void)			{ _ChangeFadeColor(); }
	virtual	void		SetFadeColor(u32 color);
	virtual	u32			GetFadeColor(void);
	virtual	xf32		GetFadeR(void)	const			{ return m_fR; }	
	virtual	xf32		GetFadeG(void)	const			{ return m_fG; }	
	virtual	xf32		GetFadeB(void)	const			{ return m_fB; }	
	// At@l
	virtual void		SetFadeAlpha(xf32 alpha)		{ m_fA = alpha; }
	virtual xf32		GetFadeAlpha(void)	const		{ return m_fA; }

protected:
	//! J[ݒ
	/// @note	pāAƎ̃tF[hNX
	virtual void		_ChangeFadeColor(void) = 0;

};

}	// end of namespace fnd
}	// end of namespace iris

#endif
