//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBitStream.h
 * @brief		bit stream t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBitStream_H_
#define INCG_IRIS_FndBitStream_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// bit stream NX
class CBitStream : public IIrisObject
{
protected:
	u8*	m_pBuffer;	//!< obt@
	u32	m_Size;		//!< obt@
	u32	m_Index;	//!< JgCfbNX
	u32	m_Bit;		//!< JgrbgCfbNX
public:
	/// RXgN^
	CBitStream(void* buf, u32 size) : m_pBuffer(reinterpret_cast<u8*>(buf)), m_Size(size)
	, m_Index(0), m_Bit(0)
	{
	}
	
public:
	/// bit o
	u32	getbit(u32 n)
	{
		IRIS_ASSERT( n <= 32 );
		u32 bit = 0;
		u32 rb = 0;
		while(n > rb)
		{
			u32 nb = (u32)(8-m_Bit);
			nb = (n-rb) > nb ? nb : n-rb;
			u32 mask = (1<<nb)-1;
			bit |= static_cast<u32>((m_pBuffer[m_Index] >> m_Bit) & mask) << rb;
			m_Bit += nb;
			rb += nb;
			
			if( m_Bit > 7 ) 
			{
				++m_Index;
				if( m_Index > m_Size ) m_Index = 0;
				m_Bit -= 8;
			}
		}
		return bit;
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
