//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndAIFF.h
 * @brief		AIFFtH[}bgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndAIFF_H_
#define INCG_IRIS_FndAIFF_H_

//======================================================================
// include
#include "../memory/FndMemBuffer.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CAIFF;

//======================================================================
// typedef
typedef s16		AIFFMarkID;

//======================================================================
// struct
/// AIFF `N
typedef struct tagAIFF_FILE_CHUNK
{
	u4cc	uID;		//!< t@Cʎq
	s32		Size;		//!< t@CTCY
	u32		uForm;		//!< tH[^Cv
} AIFF_FILE_CHUNK, *LPAIFF_FILE_CHUNK;

/// AIFF Tu`N wb_
typedef struct tagAIFF_CHUNK_HEADER
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
} AIFF_CHUNK_HEADER, *LPAIFF_CHUNK_HEADER;

/// AIFF LIST `N
typedef struct tagAIFF_LIST_CHUNK
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
	u32		uType;		//!< Xg^Cv
} AIFF_LIST_CHUNK, *LPAIFF_LIST_CHUNK;

/// AIFF Tu`N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagAIFF_CHUNK
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
	u8		pData[1];	//!< f[^
} AIFF_CHUNK, *LPAIFF_CHUNK;
#include "../../misc/iris_poppack.h"

#include "../../misc/iris_pushpack2.h"
/// AIFF COMM `N
typedef IRIS_PACKED struct tagAIFF_COMM_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s16		Channels;		//!< `l
	u32		SampleFrames;	//!< Tv
	s16		SampleSize;		//!< TvOTCY
	u32		SampleRate;		//!< TvO[g
} AIFF_COMM_CHUNK, *LPAIFF_COMM_CHUNK;
#include "../../misc/iris_poppack.h"

/// AIFF SSND `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagAIFF_SSND_CHUNK
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
	u32		Offset;		//!< 
	u32		BlockSize;	//!< 
	u8		pData[1];	//!< 
} AIFF_SSND_CHUNK, *LPAIFF_SSND_CHUNK;
#include "../../misc/iris_poppack.h"

/// AIFF Marker
typedef IRIS_PACKED struct tagAIFF_MARKER
{
	AIFFMarkID	ID;			//!< 
	u32			Position;	//!< 
	char		pString[1];	//!< 
} AIFF_MARKER, *LPAIFF_MARKER;

#include "../../misc/iris_pushpack2.h"
/// AIFF Maker `N
typedef IRIS_PACKED struct tagAIFF_MARK_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	u16		nMakers;		//!< AIFF_MAKER
	AIFF_MARKER Makers[1];	//!< AIFF_MAKER
} AIFF_MARK_CHUNK, *LPAIFF_MARK_CHUNK;
#include "../../misc/iris_poppack.h"

/// AIFF Loop 
typedef IRIS_PACKED struct tagAIFF_LOOP
{
  s16			PlayMode;	//!< 
  AIFFMarkID	BeginLoop;	//!< 
  AIFFMarkID	EndLoop;	//!< 
} AIFF_LOOP, *LPAIFF_LOOP;

#include "../../misc/iris_pushpack1.h"
/// AIFF Instrument `N
typedef IRIS_PACKED struct tagAIFF_INST_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s8		BaseNote;		//!< 
	s8		Detune;			//!< f`F[
	s8		LowNote;		//!< 
	s8		HighNote;		//!< 
	s8		LowVelocity;	//!< 
	s8		HighVelocity;	//!< 
	s8		Gain;			//!< 
	AIFF_LOOP	SustainLoop;//!< 
	AIFF_LOOP	ReleaseLoop;//!< 
} AIFF_INST_CHUNK, *LPAIFF_INST_CHUNK;
#include "../../misc/iris_poppack.h"


/// AIFF MIDI `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagAIFF_MIDI_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	u8		pData[1];		//!< f[^
} AIFF_MIDI_CHUNK, *LPAIFF_MIDI_CHUNK;
#include "../../misc/iris_poppack.h"


/// AIFF Audio Recoding `N
typedef struct tagAIFF_AESD_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	u8		AESChannelStatusData[24];		//!< f[^
} AIFF_AESD_CHUNK, *LPAIFF_AESD_CHUNK;


/// AIFF Application Specific `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagAIFF_APPL_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	u4cc	Signature;		//!< 
	u8		pData[1];		//!< f[^
} AIFF_APPL_CHUNK, *LPAIFF_APPL_CHUNK;
#include "../../misc/iris_poppack.h"


/// AIFF Rg
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagAIFF_COMMENT
{
	u32			timeStamp;		//!< ^CX^v
	AIFFMarkID	Marker;			//!< 
	u16			Count;			//!< 
	char		Text[1];		//!< Rg
} AIFF_COMMENT, *LPAIFF_COMMENT;
#include "../../misc/iris_poppack.h"

/// AIFF Comments `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagAIFF_COMT_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	u16		nComment;		//!< Rg
	char	Comments[1];	//!< Rg
} AIFF_COMT_CHUNK, *LPAIFF_COMT_CHUNK;
#include "../../misc/iris_poppack.h"


/// AIFF eLXg `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagAIFF_TEXT_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	char	Text[1];		//!< eLXg
} AIFF_TEXT_CHUNK, *LPAIFF_TEXT_CHUNK;
#include "../../misc/iris_poppack.h"

//======================================================================
// enum
// `Nʎq
typedef enum
{
	// little endian
	AIFF_ID_FILE_CHUNK	= IRIS_FOURCC_LE('F','O','R','M'),	//!< t@C
	AIFF_ID_FORMTYPE	= IRIS_FOURCC_LE('A','I','F','F'),	//!< tH[^Cv
	AIFF_ID_COMM_CHUNK	= IRIS_FOURCC_LE('C','O','M','M'),	//!< ʃ`N
	AIFF_ID_SSND_CHUNK	= IRIS_FOURCC_LE('S','S','N','D'),	//!< SSND`N
	AIFF_ID_MARK_CHUNK	= IRIS_FOURCC_LE('M','A','R','K'),	//!< MAKER`N
	AIFF_ID_INST_CHUNK	= IRIS_FOURCC_LE('I','N','S','T'),	//!< INST`N
	AIFF_ID_MIDI_CHUNK	= IRIS_FOURCC_LE('M','I','D','I'),	//!< MIDI`N
	AIFF_ID_AESD_CHUNK	= IRIS_FOURCC_LE('A','E','S','D'),	//!< AESD`N
	AIFF_ID_APPL_CHUNK	= IRIS_FOURCC_LE('A','P','P','L'),	//!< APPL`N
	AIFF_ID_COMT_CHUNK	= IRIS_FOURCC_LE('C','O','M','T'),	//!< COMT`N

	// text chunk
	AIFF_ID_NAME_CHUNK	= IRIS_FOURCC_LE('N','A','M','E'),	//!< NAME`N
	AIFF_ID_AUTH_CHUNK	= IRIS_FOURCC_LE('A','U','T','H'),	//!< AUTHOR`N
	AIFF_ID_CRIGHT_CHUNK= IRIS_FOURCC_LE('(','c',')',' '),	//!< NAME`N
	AIFF_ID_ANNO_CHUNK	= IRIS_FOURCC_LE('A','N','N','O')	//!< Annotation`N
} AIFF_CHUNK_ID;

//======================================================================
// class
/// AIFFtH[}bgt@CNX
class CAIFF : public CMemBuffer
{
public:
	// RXgN^
	CAIFF(void);
	// fXgN^
	virtual ~CAIFF(void);
public:
	// J
	bool	Open (LPCTSTR fname);
	bool	OpenA(LPCSTR  fname);
	bool	OpenW(LPCWSTR fname);
	// 
	void	Close(void);

public:
	// LȏԂǂ
	bool	IsValid(void)		const;
	// t@CTCY̎擾
	u32		GetSize(void)		const;
	// tH[^Cv̎擾
	u32		GetFormType(void)	const;

public:
	// Tu`Ň
	LPAIFF_CHUNK		FindChunk(LPAIFF_CHUNK chunk);
	// Tu`Ň
	LPAIFF_CHUNK		FindChunk(u32 ChunkType);

	// ̃`N擾
	LPAIFF_CHUNK_HEADER	GetNextChunk(const LPAIFF_CHUNK_HEADER chunk);

private:
	// ʃI[v
	bool	_Open(void);
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
