//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndAIFF.cpp
 * @brief		AIFFtH[}bgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndAIFF_CPP_

//======================================================================
// include
#include "FndAIFF.h"
#include "../io/FndFile.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAIFF::CAIFF(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CAIFF::~CAIFF(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	fname	= t@CpX
 * @return	
*//***********************************************************************/
bool CAIFF::Open (LPCTSTR fname)
{
#ifdef UNICODE
	return OpenW(fname);
#else
	return OpenA(fname);
#endif
}
/// CPHD::Open Q
bool CAIFF::OpenA(LPCSTR  fname)
{
	Close();

	CFile file;
	if( !file.OpenA(fname, FOPEN_READ) ) return false;
	u32 size = (u32)file.GetSize();

	Alloc(size, 0);
	if( !file.Read(m_pBuffer, size) ) return false;

	if( !_Open() ) 
	{
		Close();
		return false;
	}
	return true;
}
/// CPHD::Open Q
bool CAIFF::OpenW(LPCWSTR fname)
{
	Close();

	CFile file;
	if( !file.OpenW(fname, FOPEN_READ) ) return false;
	u32 size = (u32)file.GetSize();

	Alloc(size, 0);
	if( !file.Read(m_pBuffer, size) ) return false;

	if( !_Open() ) 
	{
		Close();
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CAIFF::Close(void)
{
	Dealloc();
}

/**********************************************************************//**
 *
 * LȏԂǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CAIFF::IsValid(void)	const
{
	return ( m_pBuffer != nullptr );
}

/**********************************************************************//**
 *
 * t@CTCY̎擾
 *
 ----------------------------------------------------------------------
 * @return	t@CTCY
*//***********************************************************************/
u32 CAIFF::GetSize(void)	const
{
	if( !IsValid() ) return 0;
	LPAIFF_FILE_CHUNK head = (LPAIFF_FILE_CHUNK)m_pBuffer;
	return static_cast<u32>(head->Size);
}

/**********************************************************************//**
 *
 * tH[^Cv̎擾
 *
 ----------------------------------------------------------------------
 * @return	tH[^Cv
*//***********************************************************************/
u32 CAIFF::GetFormType(void)	const
{
	if( !IsValid() ) return 0;
	LPAIFF_FILE_CHUNK head = (LPAIFF_FILE_CHUNK)m_pBuffer;
	return head->uForm;
}

/**********************************************************************//**
 *
 * Tu`Ň
 *
 ----------------------------------------------------------------------
 * @param [in] chunk	= ̎n_`N(nullptr̂Ƃ́A擪猟)
 * @return	Tu`N
*//***********************************************************************/
LPAIFF_CHUNK CAIFF::FindChunk(LPAIFF_CHUNK chunk)
{
	if( !IsValid() ) return nullptr;
	LPAIFF_FILE_CHUNK head = (LPAIFF_FILE_CHUNK)m_pBuffer;
	u32 size = static_cast<u32>(head->Size);
	u8* end  = (u8*)m_pBuffer + size;
	if( size <= sizeof(AIFF_FILE_CHUNK) ) return nullptr;

	u8* next = chunk == nullptr ? (u8*)(head + 1) : (u8*)chunk + sizeof(AIFF_CHUNK) + chunk->Size;
	while(next < end)
	{
		LPAIFF_CHUNK chunk = (LPAIFF_CHUNK)next;
		return chunk;
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * Tu`Ň
 *
 ----------------------------------------------------------------------
 * @param [in]	ChunkType	= `N^Cv
 * @return	Tu`N
*//***********************************************************************/
LPAIFF_CHUNK CAIFF::FindChunk(u32 ChunkType)
{
	if( !IsValid() ) return nullptr;
	LPAIFF_FILE_CHUNK head = (LPAIFF_FILE_CHUNK)m_pBuffer;
	u32 size = static_cast<u32>(head->Size);
	u8* end  = (u8*)m_pBuffer + size;
	if( size <= sizeof(AIFF_FILE_CHUNK) ) return nullptr;

	u8* next = (u8*)(head + 1);
	while(next < end)
	{
		LPAIFF_CHUNK chunk = (LPAIFF_CHUNK)next;
		if( chunk->uID == ChunkType )
		{
			return chunk;
		}
		else
		{
			next = next + sizeof(AIFF_CHUNK_HEADER) + chunk->Size;
		}
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * ̃`N擾
 *
 ----------------------------------------------------------------------
 * @param [in]	chunk	= ̎n_`N(nullptr̂Ƃ́A擪猟)
 * @return	̃`N
*//***********************************************************************/
LPAIFF_CHUNK_HEADER CAIFF::GetNextChunk(const LPAIFF_CHUNK_HEADER chunk)
{
	if( !IsValid() ) return nullptr;
	LPAIFF_FILE_CHUNK head = (LPAIFF_FILE_CHUNK)m_pBuffer;
	u32 size = static_cast<u32>(head->Size);
	u8* end  = (u8*)m_pBuffer + size;
	if( (size_t)size <= sizeof(AIFF_FILE_CHUNK) ) return nullptr;

	u8* next = (u8*)(head + 1);
	if( chunk != nullptr )
	{
		next = (u8*)chunk + sizeof(AIFF_CHUNK_HEADER) + chunk->Size;
	}
	if( next >= end ) return nullptr;
	return (LPAIFF_CHUNK_HEADER)next;
}

/**********************************************************************//**
 *
 * ʃI[v
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CAIFF::_Open(void)
{
	if( m_pBuffer == nullptr ) return false;
	LPAIFF_FILE_CHUNK head = (LPAIFF_FILE_CHUNK)m_pBuffer;
	if( head->uID != AIFF_ID_FILE_CHUNK ) return false;
	if( head->uForm != AIFF_ID_FORMTYPE ) return false;
	return true;
}

}	// end of namespace fnd
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"
#include <string.h>

//======================================================================
// test
IRIS_UNITTEST(CFndAIFFUnitTest, FndAIFFUnitTest)
{
	CAIFF riff;
	char path[MAX_PATH] = "sample.at3";

#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::cin >> path;
#endif

	if( !riff.OpenA(path) )
	{
		std::cout << "t@CI[vɎs܂B" << std::endl;
		goto end;
	}

	{
		std::cout << "AIFF FMT = 0x" << std::hex << riff.GetFormType() << std::dec << std::endl;
		std::cout << "------------------------------" << std::endl;
		char id_str[5];
		id_str[4] = '\0';
		LPAIFF_CHUNK_HEADER head = riff.GetNextChunk(nullptr);
		while(head != nullptr)
		{
			u32 revID = IRIS_ReverseEndian32(head->uID);
			memcpy(id_str, &revID, sizeof(revID));
			switch( head->uID )
			{
			case AIFF_ID_COMM_CHUNK:
				{
					LPAIFF_COMM_CHUNK chunk = (LPAIFF_COMM_CHUNK)head;
					std::cout << "ID           : " << id_str << std::endl;
					std::cout << "SIZE         : " << chunk->Size << std::endl;
					std::cout << "Channels     : " << chunk->Channels << std::endl;
					std::cout << "SampleFrames : " << chunk->SampleFrames << std::endl;
					std::cout << "SampleSize   : " << chunk->SampleSize << std::endl;
				}
				break;
			case AIFF_ID_SSND_CHUNK:
				{
					LPAIFF_SSND_CHUNK chunk = (LPAIFF_SSND_CHUNK)head;
					std::cout << "ID        : " << id_str << std::endl;
					std::cout << "SIZE      : " << chunk->Size << std::endl;
					std::cout << "Offset    : " << chunk->Offset << std::endl;
					std::cout << "BlockSize : " << chunk->BlockSize << std::endl;
				}
				break;
			case AIFF_ID_NAME_CHUNK:
			case AIFF_ID_AUTH_CHUNK:
			case AIFF_ID_CRIGHT_CHUNK:
			case AIFF_ID_ANNO_CHUNK:
				{
					LPAIFF_TEXT_CHUNK chunk = (LPAIFF_TEXT_CHUNK)head;
					std::cout << "ID        : " << id_str << std::endl;
					std::cout << "SIZE      : " << chunk->Size << std::endl;
					std::cout << "TEXT      : " << chunk->Text << std::endl;
				}
				break;
			default:
				{
					LPAIFF_CHUNK chunk = (LPAIFF_CHUNK)head;
					std::cout << "ID   : " << id_str << std::endl;
					std::cout << "SIZE : " << chunk->Size << std::endl;
				}
				break;
			}
			std::cout << "------------------------------" << std::endl;
			head = (LPAIFF_CHUNK_HEADER)riff.GetNextChunk(head);
		}
	}
end:
	return;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
