//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndIEEE.h
 * @brief		IEEE t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndIEEE_H_
#define INCG_IRIS_FndIEEE_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"
#include "../../ml/iml_math.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<typename ttTN, int tiSIGN, int tiEXP, int tiFUNC, int tiBIAS>class CIEEE754;

//======================================================================
// typedef
typedef CIEEE754<int, 1, 8, 23, 127>				CIEEEBinary32;


//======================================================================
// class
/**
 * @brief	IEEE 754 _NX
 * @tparam ttTN		= i[鐮^
 * @tparam tiSIGN	= ̃rbg(0 or 1)
 * @tparam tiEXP	= w
 * @tparam tiFUNC	= 
 * @tparam tiBIAS	= w̃oCAX
*/
template<typename ttTN, int tiSIGN, int tiEXP, int tiFUNC, int tiBIAS = ::iml::static_pow<2, tiEXP-1>::value-1 >
class CIEEE754 : public IIrisObject
{
	typedef	ttTN	value_type;
	typedef CIEEE754<ttTN, tiSIGN, tiEXP, tiFUNC, tiBIAS>	_Myt;
	typedef CIEEEBinary32									floatType;

	IRIS_STATIC_ASSERT( tiSIGN == 0 || tiSIGN == 1 );
public:
	static const int SIGN = tiSIGN;	//!< ̃rbg
	static const int EXP  = tiEXP;	//!< w̃rbg
	static const int FUNC = tiFUNC;	//!< ̃rbg
	static const int BIAS = tiBIAS;	//!< w̃oCAXl

public:
	static const value_type	PINF = iml::static_mask<EXP, FUNC>::value;		//!< + 
	static const value_type	NINF = iml::static_mask<EXP+SIGN, FUNC>::value;	//!< - 

private:
	value_type	m_value;	//!< l

public:
	/**
	 * @name RXgN^
	 * @{
	*/
	CIEEE754(void) : m_value(0) {}
	CIEEE754(float f) : m_value(0) { cast_from_float(f); }
	CIEEE754(const _Myt& rhs) : m_value(rhs.m_value) {}
	template<typename ttXTN, int tiXSIGN, int tiXEXP, int tiXFUNC, int tiXBIAS>
	CIEEE754(const CIEEE754<ttXTN, tiXSIGN, tiXEXP, tiXFUNC, tiXBIAS>& ieee) : m_value(0) { cast_from_ieee(ieee); }
	/**
	 * @}
	*/
public:
	/**
	 * @name	operator
	 * @{
	*/
	_Myt& operator = (float rhs)	{ cast_from_float(rhs); return *this; }
	template<typename _XTN, int _XSIGN, int _XEXP, int _XFUNC, int _XBIAS>
	_Myt& operator = (const CIEEE754<_XTN, _XSIGN, _XEXP, _XFUNC, _XBIAS>& ieee) { cast_from_ieee(ieee); return *this; }

	operator float (void)	const		{ return cast_to_float(); }
	/**
	 * @}
	*/

public:
	//! l̎擾
	value_type		value(void)	const	{ return m_value; }

private:
	// LXg
	void	cast_from_float(float f)
	{
		IrisFInt fi = f;

		value_type exp = (((fi.iv >> floatType::FUNC) & iml::static_mask<floatType::EXP>::value) - floatType::BIAS + BIAS);
		if( exp >= iml::static_lshift<1, EXP>::value )
		{
			// INF
			m_value = (((exp>>(sizeof(exp)-1))&0x1)<<EXP) | iml::static_mask<EXP>::value;
			m_value <<= FUNC;
			return;
		}
		m_value  = (value_type)(iml::signed_rshift<IrisU32, (floatType::FUNC+floatType::EXP)-(FUNC+EXP)>::shift(fi.iv) & iml::static_mask<1, EXP+FUNC>::value);
		m_value |= exp << FUNC;
		m_value |= iml::signed_rshift<IrisU32, floatType::FUNC-FUNC>::shift( fi.iv & iml::static_mask<floatType::FUNC>::value );
	}
	template<typename _XTN, int _XSIGN, int _XEXP, int _XFUNC, int _XBIAS>
	void	cast_from_ieee(const CIEEE754<_XTN, _XSIGN, _XEXP, _XFUNC, _XBIAS>& ieee)
	{
		_XTN value = ieee.value();
		value_type exp = (((value >> ieee.FUNC) & iml::static_mask<ieee.EXP>::value) - ieee.BIAS + BIAS);
		if( exp >= iml::static_lshift<1, EXP>::value )
		{
			// INF
			m_value = (((exp>>(sizeof(exp)-1))&0x1)<<EXP) | iml::static_mask<EXP>::value;
			m_value <<= FUNC;
			return;
		}
		m_value  = (value_type)(iml::signed_rshift<IrisU32, (ieee.FUNC+ieee.EXP)-(FUNC+EXP)>::shift(value) & iml::static_mask<1, EXP+FUNC>::value);
		m_value |= exp << FUNC;
		m_value |= iml::signed_rshift<IrisU32, ieee.FUNC-FUNC>::shift( value & iml::static_mask<ieee.FUNC>::value );
	}

	float	cast_to_float(void)	const
	{
		floatType ieee(*this);
		IrisFInt fi = ieee.value();
		return fi.fv;
	}

private:
	// 
	value_type		sign(void)				{ return (m_value >> (EXP+FUNC)) & iml::static_mask<SIGN>::value; }
	void			sign(value_type s)		{ m_value &= (((value_type)1) << (EXP+FUNC)); m_value |= ((s&1) << (EXP+FUNC)); }

	// w
	value_type		exp(void)				{ return (m_value >> FUNC) & iml::static_mask<EXP>::value; }
	void			exp(value_type e)		{ m_value &= iml::static_mask<EXP, FUNC>::value; m_value |= (e&iml::static_mask<EXP>::value) << FUNC; }

	// 
	value_type		func(void)				{ return m_value & iml::static_mask<FUNC>::value; }
	void			func(value_type f)		{ m_value &= iml::static_mask<FUNC>::value; m_value |= f&iml::static_mask<FUNC>::value; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
