//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFuzzyVariable.h
 * @brief		Fuzzy_ϐNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndFuzzyVariable_H_
#define INCG_IRIS_FndFuzzyVariable_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CFuzzyVariable;
class IFuzzyFunc;

//======================================================================
// class
//------------------------------
//! Fuzzy_ϐNX
class CFuzzyVariable : public IIrisObject
{
private:
	xf32		m_Fuzzy;	//!< Fuzzyl(0`1)
public:
	/// RXgN^
	CFuzzyVariable(void) : m_Fuzzy(XF32_ZERO) {}
	/// RXgN^
	CFuzzyVariable(xf32 fuzzy) : m_Fuzzy(fuzzy) { ValidateFuzzy(); }
	/// RXgN^
	CFuzzyVariable(const CFuzzyVariable& rFuzzy) : m_Fuzzy(rFuzzy.m_Fuzzy) { ValidateFuzzy(); }

	/// fXgN^
	//~CFuzzyVariable(void);
public:
	/// LXg 
	operator xf32 (void)	{ return m_Fuzzy; }

public:
	/// Fuzzyl
	CFuzzyVariable&	operator = (xf32 fuzzy)							{ SetFuzzy(fuzzy); ValidateFuzzy(); return *this; }
	/// Fuzzyl
	CFuzzyVariable&	operator = (const CFuzzyVariable& rFuzzy)		{ SetFuzzy(rFuzzy.m_Fuzzy); return *this; }

	/// FuzzyZ
	CFuzzyVariable	operator + (xf32 fuzzy)					{ return CFuzzyVariable( m_Fuzzy + fuzzy ); }
	/// FuzzyZ
	CFuzzyVariable	operator - (xf32 fuzzy)					{ return CFuzzyVariable( m_Fuzzy - fuzzy ); }
	/// FuzzyZ
	CFuzzyVariable	operator * (xf32 fuzzy)					{ return CFuzzyVariable( XF_Mul(m_Fuzzy, fuzzy) ); }
	/// FuzzyZ
	CFuzzyVariable	operator / (xf32 fuzzy)					{ return CFuzzyVariable( XF_Div(m_Fuzzy, fuzzy) ); }

	/// FuzzyZ
	CFuzzyVariable	operator + (const CFuzzyVariable& rV)	{ return CFuzzyVariable( m_Fuzzy + rV.m_Fuzzy ); }
	/// FuzzyZ
	CFuzzyVariable	operator - (const CFuzzyVariable& rV)	{ return CFuzzyVariable( m_Fuzzy - rV.m_Fuzzy ); }
	/// FuzzyZ
	CFuzzyVariable	operator * (const CFuzzyVariable& rV)	{ return CFuzzyVariable( XF_Mul(m_Fuzzy, rV.m_Fuzzy) ); }
	/// FuzzyZ
	CFuzzyVariable	operator / (const CFuzzyVariable& rV)	{ return CFuzzyVariable( XF_Div(m_Fuzzy, rV.m_Fuzzy) ); }
	/// Fuzzy_a
	CFuzzyVariable	operator | (const CFuzzyVariable& rV)	{ return CFuzzyVariable( (m_Fuzzy > rV.m_Fuzzy) ? m_Fuzzy : rV.m_Fuzzy ); }
	/// Fuzzy_
	CFuzzyVariable	operator & (const CFuzzyVariable& rV)	{ return CFuzzyVariable( (m_Fuzzy < rV.m_Fuzzy) ? m_Fuzzy : rV.m_Fuzzy ); }
	/// Fuzzyے
	CFuzzyVariable	operator ~ (void)						{ return CFuzzyVariable( XF32_ONE - m_Fuzzy ); }

	/// FuzzyZ
	CFuzzyVariable&	operator += (const CFuzzyVariable& rV)	{ m_Fuzzy += rV.m_Fuzzy; ValidateFuzzy(); return *this; }
	/// FuzzyZ
	CFuzzyVariable&	operator -= (const CFuzzyVariable& rV)	{ m_Fuzzy -= rV.m_Fuzzy; ValidateFuzzy(); return *this; }
	/// FuzzyZ
	CFuzzyVariable&	operator *= (const CFuzzyVariable& rV)	{ m_Fuzzy *= rV.m_Fuzzy; ValidateFuzzy(); return *this; }
	/// FuzzyZ
	CFuzzyVariable&	operator /= (const CFuzzyVariable& rV)	{ m_Fuzzy /= rV.m_Fuzzy; ValidateFuzzy(); return *this; }
	/// Fuzzy_a
	CFuzzyVariable&	operator |= (const CFuzzyVariable& rV)	{ if( m_Fuzzy < rV.m_Fuzzy ) m_Fuzzy = rV.m_Fuzzy; return *this; }
	/// Fuzzy_
	CFuzzyVariable&	operator &= (const CFuzzyVariable& rV)	{ if( m_Fuzzy > rV.m_Fuzzy ) m_Fuzzy = rV.m_Fuzzy; return *this; }

public:
	/// Fuzzylݒ
	void	SetFuzzy(xf32 fuzzy)	{ m_Fuzzy = fuzzy; ValidateFuzzy(); }
	/// Fuzzyl擾
	xf32	GetFuzzy(void)	const	{ return m_Fuzzy; }

public:
	/// Fuzzyl0`1Ɏ߂
	void	ValidateFuzzy(void)		{ if( m_Fuzzy > XF32_ONE ) m_Fuzzy = XF32_ONE; if( m_Fuzzy < XF32_ZERO ) m_Fuzzy = XF32_ZERO; }
};

//------------------------------
//! Fuzzy֐NXC^[tFCX
class IFuzzyFunc : public IIrisObject
{
public:
	/// RXgN^
	IFuzzyFunc(void)	{}
public:
	/// Fuzzyl̐
	virtual CFuzzyVariable	Calc(xf32 real)	= 0;
};

//! `XΌ^Fuzzy֐
class CFuzzyFuncGrade : public IFuzzyFunc
{
	xf32 m_X0, m_X1;
public:
	/// RXgN^
	CFuzzyFuncGrade(void) : m_X0(XF32_ZERO), m_X1(XF32_ZERO)	{}
	/// RXgN^
	CFuzzyFuncGrade(xf32 x0, xf32 x1) : m_X0(x0), m_X1(x1)		{}
public:
	/// p[^̐ݒ
	void	SetParams(xf32 x0, xf32 x1)	{ m_X0 = x0; m_X1 = x1; }
public:
	/// Fuzzyl̐
	virtual CFuzzyVariable	Calc(xf32 real);
};

//------------------------------
//! `tXΌ^Fuzzy֐
class CFuzzyFuncReverseGrade : public IFuzzyFunc
{
	xf32 m_X0, m_X1;
public:
	/// RXgN^
	CFuzzyFuncReverseGrade(void) : m_X0(XF32_ZERO), m_X1(XF32_ZERO)	{}
	/// RXgN^
	CFuzzyFuncReverseGrade(xf32 x0, xf32 x1) : m_X0(x0), m_X1(x1)	{}
public:
	/// p[^̐ݒ
	void	SetParams(xf32 x0, xf32 x1)	{ m_X0 = x0; m_X1 = x1; }
public:
	/// Fuzzyl̐
	virtual CFuzzyVariable	Calc(xf32 real);
};

//------------------------------
//! `Op`^Fuzzy֐
class CFuzzyFuncTriangle : public IFuzzyFunc
{
	xf32 m_X0, m_X1, m_X2;
public:
	/// RXgN^
	CFuzzyFuncTriangle(void) : m_X0(XF32_ZERO), m_X1(XF32_ZERO), m_X2(XF32_ZERO)	{}
	/// RXgN^
	CFuzzyFuncTriangle(xf32 x0, xf32 x1, xf32 x2) : m_X0(x0), m_X1(x1), m_X2(x2)	{}
public:
	/// p[^̐ݒ
	void	SetParams(xf32 x0, xf32 x1, xf32 x2)	{ m_X0 = x0; m_X1 = x1; m_X2 = x2; }
public:
	/// Fuzzyl̐
	virtual CFuzzyVariable	Calc(xf32 real);
};

//------------------------------
//! ``^Fuzzy֐
class CFuzzyFuncTrapezoid : public IFuzzyFunc
{
	xf32 m_X0, m_X1, m_X2, m_X3;
public:
	/// RXgN^
	CFuzzyFuncTrapezoid(void)	: m_X0(XF32_ZERO), m_X1(XF32_ZERO), m_X2(XF32_ZERO), m_X3(XF32_ZERO)	{}
	/// RXgN^
	CFuzzyFuncTrapezoid(xf32 x0, xf32 x1, xf32 x2, xf32 x3)	: m_X0(x0), m_X1(x1), m_X2(x2), m_X3(x3)	{}
public:
	/// p[^̐ݒ
	void	SetParams(xf32 x0, xf32 x1, xf32 x2, xf32 x3)	{ m_X0 = x0; m_X1 = x1; m_X2 = x2; m_X3 = x3; }
public:
	/// Fuzzyl̐
	virtual CFuzzyVariable	Calc(xf32 real);
};

//------------------------------
//! u[_ON^Fuzzy֐
class CFuzzyFuncRiseBool : public IFuzzyFunc
{
	xf32 m_X0;
public:
	/// RXgN^
	CFuzzyFuncRiseBool(void) : m_X0(XF32_ZERO)	{}
	/// RXgN^
	CFuzzyFuncRiseBool(xf32 x0) : m_X0(x0)		{}
public:
	/// p[^̐ݒ
	void	SetParams(xf32 x0)	{ m_X0 = x0; }
public:
	/// Fuzzyl̐
	virtual CFuzzyVariable	Calc(xf32 real);
};

//------------------------------
//! u[_OFF^Fuzzy֐
class CFuzzyFuncFallBool : public IFuzzyFunc
{
	xf32 m_X0;
public:
	/// RXgN^
	CFuzzyFuncFallBool(void) : m_X0(XF32_ZERO)	{}
	/// RXgN^
	CFuzzyFuncFallBool(xf32 x0) : m_X0(x0)		{}
public:
	/// p[^̐ݒ
	void	SetParams(xf32 x0)	{ m_X0 = x0; }
public:
	/// Fuzzyl̐
	virtual CFuzzyVariable	Calc(xf32 real);
};

//------------------------------
//! u[_`^Fuzzy֐
class CFuzzyFuncRectBool : public IFuzzyFunc
{
	xf32 m_X0, m_X1;
public:
	/// RXgN^
	CFuzzyFuncRectBool(void) : m_X0(XF32_ZERO), m_X1(XF32_ZERO)	{}
	/// RXgN^
	CFuzzyFuncRectBool(xf32 x0, xf32 x1) : m_X0(x0), m_X1(x1)	{}
public:
	/// p[^̐ݒ
	void	SetParams(xf32 x0, xf32 x1)	{ m_X0 = x0; m_X1 = x1; }
public:
	/// Fuzzyl̐
	virtual CFuzzyVariable	Calc(xf32 real);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
