//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFixedFloat.h
 * @brief		Œ菬 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndFixedFloat_H_
#define INCG_IRIS_FndFixedFloat_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"
#include "../../ml/iml_math.hpp"
#include "../../ml/iml_type_select.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// declare

//======================================================================
// class
/**
 * @brief	Œ菬_NX
 * @tparam ttTN		= i[鐮^
 * @tparam tiINT	= ̃rbg
 * @tparam tiDEC	= ̃rbg
 * @tparam tiSIGN	= ̃rbg(0 or 1)
*/
template<typename ttTN, int tiINT, int tiDEC, int tiSIGN=1 >
class CFixedFloat : public IIrisObject
{
	typedef	ttTN	value_type;
	typedef CFixedFloat<ttTN, tiINT, tiDEC, tiSIGN>	_Myt;

	IRIS_STATIC_ASSERT( tiSIGN == 0 || tiSIGN == 1 );
public:
	static const int SIGN		= tiSIGN;	//!< ̃rbg
	static const int INTSIZE	= tiINT;	//!< ̃rbg
	static const int DECSIZE	= tiDEC;	//!< ̃rbg
	static const int SHIFT		= DECSIZE;	//!< Vtgl

public:
	static const int ONE		= iml::static_lshift<1, DECSIZE>::value;	//!< 1

private:

#if	defined(IRIS_GNUC)
	static const float F_ONE	= (float)ONE;
#else
	static const float F_ONE;
#endif

private:
	value_type	m_value;	//!< l

public:
	/**
	 * @name RXgN^
	 * @{
	*/
	CFixedFloat(void) : m_value(0) {}
	CFixedFloat(float f) : m_value(0) { cast_from_float(f); }
	CFixedFloat(const _Myt& rhs) : m_value(rhs.m_value) {}
	template<typename ttXTN, int tiXINT, int tiXDEC, int tiXSIGN>
	CFixedFloat(const CFixedFloat<ttXTN, tiXINT, tiXDEC, tiXSIGN>& fx) : m_value(0) { cast_from_fx(fx); }
	/**
	 * @}
	*/
public:
	/**
	 * @name	operator
	 * @{
	*/
	_Myt& operator = (float rhs)	{ cast_from_float(rhs); return *this; }
	template<typename ttXTN, int tiXINT, int tiXDEC, int tiXSIGN>
	_Myt& operator = (const CFixedFloat<ttXTN, tiXINT, tiXDEC, tiXSIGN>& fx) { cast_from_fx(fx); return *this; }

	operator float (void)	const		{ return cast_to_float(); }
	/**
	 * @}
	*/

public:
	/**
	 * @name	operator
	 * @{
	*/
	const _Myt&		operator +	(const _Myt& rhs)	const	{ _Myt ret(*this); ret += rhs; return ret; }
	_Myt&			operator +=	(const _Myt& rhs)			{ m_value += rhs.m_value; return *this; }
	const _Myt&		operator -	(const _Myt& rhs)	const	{ _Myt ret(*this); ret -= rhs; return ret; }
	_Myt&			operator -=	(const _Myt& rhs)			{ m_value -= rhs.m_value; return *this; }
	const _Myt&		operator *	(const _Myt& rhs)	const	{ _Myt ret(*this); ret *= rhs; return ret; }
	_Myt&			operator *=	(const _Myt& rhs)			{ m_value *= rhs.m_value; m_value >>= SHIFT; return *this; }

	/**
	 * @}
	*/

public:
	//! l̎擾
	value_type		value(void)	const	{ return m_value; }

private:
	// LXg
	void	cast_from_float(float f)
	{
		m_value = (value_type)( (f > 0.f) ? (f * ONE + 0.5f) : (f * ONE - 0.5f) );
	}
	template<typename ttXTN, int tiXINT, int tiXDEC, int tiXSIGN>
	void	cast_from_fx(const CFixedFloat<ttXTN, tiXINT, tiXDEC, tiXSIGN>& fx)
	{
		typedef iml::type_select< (sizeof(value_type) <= sizeof(ttXTN)), ttXTN, value_type >::type TYPE;
		TYPE v = (TYPE)(fx.value() & iml::static_mask<fx.INTSIZE + fx.DECSIZE>::value);

		m_value = (value_type)(fx.value() & iml::static_mask<fx.SIGN, fx.INTSIZE + fx.DECSIZE>::value);
		m_value |= iml::signed_rshift<TYPE, fx.DECSIZE - DECSIZE>::shift( v ) & iml::static_mask<INTSIZE + DECSIZE>::value;
	}

	float	cast_to_float(void)	const
	{
		return m_value / F_ONE;
	}

private:
	// 
	value_type		sign(void)				{ return (m_value >> (INTSIZE+DECSIZE)) & iml::static_mask<SIGN>::value; }
	void			sign(value_type s)		{ m_value &= iml::static_mask<SIGN, INTSIZE+DECSIZE>::value; m_value |= (i&iml::static_mask<SIGN>::value) << (INTSIZE+DECSIZE); }

	// 
	value_type		integer(void)			{ return (m_value >> DECSIZE) & iml::static_mask<INTSIZE>::value; }
	void			integer(value_type i)	{ m_value &= iml::static_mask<INTSIZE, DECSIZE>::value; m_value |= (i&iml::static_mask<INTSIZE>::value) << DECSIZE; }

	// 
	value_type		decimal(void)			{ return m_value & iml::static_mask<DECSIZE>::value; }
	void			decimal(value_type d)	{ m_value &= iml::static_mask<DECSIZE>::value; m_value |= d&iml::static_mask<DECSIZE>::value; }
};

#if	!defined(IRIS_GNUC)

template<typename ttTN, int tiINT, int tiDEC, int tiSIGN >
const float CFixedFloat<ttTN, tiINT, tiDEC, tiSIGN>::F_ONE = (float)(CFixedFloat<ttTN, tiINT, tiDEC, tiSIGN>::ONE);

#endif

}	// end of namespace fnd
}	// end of namespace iris

#endif
