//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndScene.cpp
 * @brief		V[ǗNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndScene_CPP_

//======================================================================
// include
#include "FndScene.h"

namespace iris {
namespace fnd
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CScene::CScene(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CScene::~CScene(void)
{
}

/**********************************************************************//**
 *
 * C[̒ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	layer	= C[
*//***********************************************************************/
void CScene::AddLayer(CDrawLayer* layer)
{
	m_Layer.push_back(layer);
}

/**********************************************************************//**
 *
 * C[̑}
 *
 ----------------------------------------------------------------------
 * @param [in]	layer_id	= C[ID
 * @param [in]	layer		= C[
*//***********************************************************************/
void CScene::InsertLayer(s32 layer_id, CDrawLayer* layer)
{
	CList<CDrawLayer>::iterator it = m_Layer.find(CDrawLayer(layer_id));
	if( it != it.null() )
		m_Layer.insert(it, layer);
}

/**********************************************************************//**
 *
 * C[̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	layer_id	= C[ID
*//***********************************************************************/
void CScene::EraseLayer(s32 layer_id)
{
	CList<CDrawLayer>::iterator it = m_Layer.find(CDrawLayer(layer_id));
	m_Layer.erase(it);
}

/**********************************************************************//**
 *
 * C[̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	layer	= C[
*//***********************************************************************/
void CScene::EraseLayer(CDrawLayer* layer)
{
	m_Layer.erase(layer);
}

/**********************************************************************//**
 *
 * C[̎擾
 *
 ----------------------------------------------------------------------
 * @return	C[
*//***********************************************************************/
CDrawLayer* CScene::GetLayer(s32 layer_id)
{
	return &m_Layer.find(CDrawLayer(layer_id));
}

/**********************************************************************//**
 *
 * Oɓo^
 *
 ----------------------------------------------------------------------
 * @param [in]	node	= m[h
*//***********************************************************************/
void CScene::RegistPreUpdater(CUpdateNode* node)
{
	m_PreUpdate.push_back(node);
}

/**********************************************************************//**
 *
 * XVɓo^
 *
 ----------------------------------------------------------------------
 * @param [in]	node	= m[h
*//***********************************************************************/
void CScene::RegistUpdater(CUpdateNode* node)
{
	m_Update.push_back(node);
}

/**********************************************************************//**
 *
 * ㏈ɓo^
 *
 ----------------------------------------------------------------------
 * @param [in]	node	= m[h
*//***********************************************************************/
void CScene::RegistPostUpdater(CUpdateNode* node)
{
	m_PostUpdate.push_back(node);
}

/**********************************************************************//**
 *
 * `揈ɓo^
 *
 ----------------------------------------------------------------------
 * @param [in]	layer_id	= C[ID
 * @param [in]	node		= m[h
*//***********************************************************************/
void CScene::RegistDrawer(s32 layer_id, CDrawNode* node)
{
	m_Layer.find(CDrawLayer(layer_id))->PushBack(node);
}

/**********************************************************************//**
 *
 * O폜
 *
 ----------------------------------------------------------------------
 * @param [in]	node	= m[h
*//***********************************************************************/
void CScene::ErasePreUpdater(CUpdateNode* node)
{
	m_PreUpdate.erase(node);
}

/**********************************************************************//**
 *
 * XV폜
 *
 ----------------------------------------------------------------------
 * @param [in]	node	= m[h
*//***********************************************************************/
void CScene::EraseUpdater(CUpdateNode* node)
{
	m_Update.erase(node);
}

/**********************************************************************//**
 *
 * ㏈폜
 *
 ----------------------------------------------------------------------
 * @param [in]	node	= m[h
*//***********************************************************************/
void CScene::ErasePostUpdater(CUpdateNode* node)
{
	m_PostUpdate.erase(node);
}

/**********************************************************************//**
 *
 * `揈폜
 *
 ----------------------------------------------------------------------
 * @param [in]	layer_id	= C[ID
 * @param [in]	node	= m[h
*//***********************************************************************/
void CScene::EraseDrawer(s32 layer_id, CDrawNode* node)
{
	m_Layer.find(CDrawLayer(layer_id))->Erase(node);
}

/**********************************************************************//**
 *
 * XVO
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CScene::PreUpdate(xf32 time)
{
	for( CUpdateCollector::iterator it = m_PreUpdate.begin(), end = m_PreUpdate.end(); it != end; ++it )
	{
		(*it)->Update(time);
	}
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CScene::Update(xf32 time)
{
	for( CUpdateCollector::iterator it = m_Update.begin(), end = m_Update.end(); it != end; ++it )
	{
		(*it)->Update(time);
	}
}

/**********************************************************************//**
 *
 * XV㏈
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CScene::PostUpdate(xf32 time)
{
	for( CUpdateCollector::iterator it = m_PostUpdate.begin(), end = m_PostUpdate.end(); it != end; ++it )
	{
		(*it)->Update(time);
	}
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CScene::Draw(void)
{
	for( CList<CDrawLayer>::iterator it = m_Layer.begin(), end = m_Layer.end(); it != end; ++it )
	{
		CDrawLayer* p = &it;
		p->PreDraw();
		p->Draw();
		p->PostDraw();
	}
}


}	// end of namespace fnd
}	// end of namespace iris

