//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndLayer.cpp
 * @brief		C[NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndLayer_CPP_

//======================================================================
// include
#include "FndLayer.h"

namespace iris {
namespace fnd
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	id	= C[ID
*//***********************************************************************/
CDrawLayer::CDrawLayer(s32 id)
: m_ID(id)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDrawLayer::~CDrawLayer(void)
{
}

/**********************************************************************//**
 *
 * Xgɒǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	drawer	= `m[h
*//***********************************************************************/
void CDrawLayer::PushBack(CDrawNode* drawer)
{
	m_List.push_back(drawer);
}

/**********************************************************************//**
 *
 * Xgɑ}
 *
 ----------------------------------------------------------------------
 * @param [in]	pos		= }ʒu
 * @param [in]	drawer	= `m[h
*//***********************************************************************/
void CDrawLayer::Insert(CDrawCollector::iterator pos, CDrawNode* drawer)
{
	m_List.insert(pos, drawer);
}

/**********************************************************************//**
 *
 * Xg폜
 *
 ----------------------------------------------------------------------
 * @param [in]	drawer	= `m[h
*//***********************************************************************/
void CDrawLayer::Erase(CDrawNode* drawer)
{
	m_List.erase(drawer);
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CDrawLayer::Draw(void)
{
	for( CDrawCollector::iterator it = m_List.begin(), end = m_List.end(); it != end; ++it )
	{
		(*it)->Draw();
	}
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	id	= C[ID
*//***********************************************************************/
CSortDrawLayer::CSortDrawLayer(s32 id)
: CDrawLayer(id)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSortDrawLayer::~CSortDrawLayer(void)
{
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CSortDrawLayer::Draw(void)
{
	m_List.sort();
	CDrawLayer::Draw();
}

}	// end of namespace fnd
}	// end of namespace iris

