//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndMemory.cpp
 * @brief		t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndMemory_C_

//======================================================================
// include
#include "FndMemory.h"
#include "../../iris_debug.h"
#include <stdlib.h>

EXTERN_C_BEGIN

//======================================================================
// variable
static PFN_FndMalloc	s_pfnMalloc = irisDefaultAlloc;
static PFN_FndFree		s_pfnFree	= irisDefaultFree;
#ifdef _IRIS_DEBUG
static int			s_initialize= 0;
#endif

//======================================================================
// function

/**
 * @brief	̊mہE֐̏
 * @param [in]	pfnAlloc	= mۊ֐|C^
 * @param [in]	pfnFree		= ֐|C^
*/
void	irisInitMemoryFunc(PFN_FndMalloc pfnAlloc, PFN_FndFree pfnFree)
{
#ifdef _IRIS_DEBUG
	IRIS_ASSERT( s_initialize == 0 );
	s_initialize = 1;
#endif
	s_pfnMalloc = pfnAlloc;
	s_pfnFree = pfnFree;
}

/**
 * @brief	̊m
 * @param [in]	size	= ̈TCY
 * @param [in]	arg		= 
 * @return	mۂ̈AhX
*/
void*	irisAlloc(IrisU32 size, IrisS32 arg)
{
	return (*s_pfnMalloc)(size, arg);
}

/**
 * @brief	̉
 * @param [in]	ptr	= AhX
*/
void	irisFree(void* ptr)
{
	(*s_pfnFree)(ptr);
}


/**
 * @brief	ftHg̊m
 * @param [in]	size	= ̈TCY
 * @param [in]	arg		= 
 * @return	mۂ̈AhX
*/
void*	irisDefaultAlloc(IrisU32 size, IrisS32 arg)
{
	IRIS_UNUSED_VARIABLE(arg);
	return (void*)malloc(size);
}

/**
 * @brief	ftHg̉
 * @param [in]	ptr	= AhX
*/
void	irisDefaultFree(void* ptr)
{
	free(ptr);
}

EXTERN_C_END
