//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFile.h
 * @brief		FILENXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndIFile_H_
#define INCG_IRIS_FndIFile_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// enum
/// Open [h
typedef enum
{
	FOPEN_READ		= 0x00000001,	//!< ǂݍ
	FOPEN_WRITE		= 0x00000002,	//!< 
	FOPEN_RW		= FOPEN_READ|FOPEN_WRITE,	//!< ǂݏ
	FOPEN_NONBLOCK	= 0x00000004,	//!< non blocking [h
	FOPEN_READLOCK	= 0x00000010,	//!< ǂݍ݃bN( non shared )
	FOPEN_WRITELOCK	= 0x00000020,	//!< ݃bN( non shared )
	FOPEN_APPEND	= 0x00000100,	//!< ǉ݃[h
	FOPEN_CREATE	= 0x00000200,	//!< t@CȂƂɍ쐬
	FOPEN_TRUNC		= 0x00000400,	//!< ej(0byte)ĊJ
	FOPEN_CREATENEW	= 0x00000800,	//!< FOPEN_CREATEw肵ƂɁAt@C݂ƃG[Ƃ 
	FOPEN_EXCL		= 0x01000000,	//!< t@CI[vXbĥݑ싖
	FOPEN_POWERLOCK	= 0x02000000,	//!< t@C쒆̓d֎~
	FOPEN_MASK		= 0x03000f37
} OPEN_MODE;
/// seek[h
typedef enum
{
	FILE_SEEK_SET = 0,	//!< 擪
	FILE_SEEK_CUR,		//!< Jgʒu
	FILE_SEEK_END,		//!< I[
	FILE_SEEK_MODE_NUM
} SEEK_MODE;

//======================================================================
// class
//! FILENX C^[tFCX
class IFile : public INonCopyable<IFile>
{
public:
	// RXgN^
	IFile(void)				{}
	// fXgN^
	virtual ~IFile(void)	{}
public:
	// J
	virtual bool	Open (LPCTSTR lpFileName, u32 mode)
	{
#ifdef UNICODE
		return OpenW(lpFileName, mode);
#else
		return OpenA(lpFileName, mode);
#endif
	}
	virtual bool	OpenA(LPCSTR  lpFileName, u32 mode)	= 0;
	virtual bool	OpenW(LPCWSTR lpFileName, u32 mode)	= 0;
	virtual bool	IsOpen(void)	const	= 0;
	// 
	virtual int		Close(void)	= 0;
	// seek
	virtual int		Seek(long offset, int origin)	= 0;
	// tell
	virtual s32		Tell(void)		const	= 0;
	// t@CTCY擾
	virtual u32		GetSize(void)	const	= 0;

	// ǂݍ
	virtual size_t	Read(void* buf, u32 size)		= 0;
	virtual size_t	ReadAsync(void* buf, u32 size)	= 0;
	// 
	virtual size_t	Write(void* buf, u32 size)		= 0;
	virtual size_t	WriteAsync(void* buf, u32 size)	= 0;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
