//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFile.h
 * @brief		FILENXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndFile_H_
#define INCG_IRIS_FndFile_H_

//======================================================================
// include
#include <stdio.h>
#include "FndIFile.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
//! FILENX
class CFile : public IFile
{
private:
	// 
	FILE*	m_fp;
public:
	// set, get
	FILE*	GetFilePtr(void)	{ return m_fp; }
    // FILE*̎擾
	FILE*	operator()(void)	{ return GetFilePtr(); }
public:
	// RXgN^
	CFile(void);
	// fXgN^
	virtual ~CFile(void);

public:
	// ֘At
	bool	Attach(FILE* fp);
	// ֘At
	FILE*	Detach(void);

public:
	// J
	bool	Open (LPCTSTR lpFileName, LPCTSTR mode);
	bool	OpenA(LPCSTR  lpFileName, LPCSTR  mode);
	bool	OpenW(LPCWSTR lpFileName, LPCWSTR mode);

	// ǂݍ
	size_t	Read(void* buf, u32 size, u32 n);
	// 
	size_t	Write(void* buf, u32 size, u32 n);


public:
	// J
	virtual bool	Open (LPCTSTR lpFileName, u32 mode)		{ return IFile::Open(lpFileName, mode); }
	virtual bool	OpenA(LPCSTR  lpFileName, u32 mode);
	virtual bool	OpenW(LPCWSTR lpFileName, u32 mode);
	virtual bool	IsOpen(void)	const;
	// 
	virtual	int		Close(void);
	// seek
	virtual int		Seek(long offset, int origin);
	// tell
	virtual s32		Tell(void)		const;
	// t@CTCY擾
	virtual u32		GetSize(void)	const;

	// ǂݍ
	virtual size_t	Read(void* buf, u32 size);
	virtual size_t	ReadAsync(void* buf, u32 size);
	// 
	virtual size_t	Write(void* buf, u32 size);
	virtual size_t	WriteAsync(void* buf, u32 size);

	// 1sǂݍ
	LPTSTR	ReadLine (LPTSTR buf, int size);
	LPSTR	ReadLineA(LPSTR  buf, int size);
	LPWSTR	ReadLineW(LPWSTR buf, int size);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
