//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndEdgeDetector.h
 * @brief		GbWot@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndEdgeDetector_H_
#define INCG_IRIS_FndEdgeDetector_H_

//======================================================================
// include
#include "FndImage.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// GbWoNX
class CEdgeDetector : public IIrisObject
{
public:
	enum
	{
		MAX_KERNEL		= 2,	//!< RA̍őێ
		KERNEL_BOX_X	= 3,	//!< x̃RAvf
		KERNEL_BOX_Y	= 3,	//!< ỹRAvf
		KERNEL_BOX_NUM	= KERNEL_BOX_X*KERNEL_BOX_Y	//!< RA̗vf
	};
	enum
	{
		KERNEL_X_OFS = (KERNEL_BOX_X>>1),
		KERNEL_Y_OFS = (KERNEL_BOX_Y>>1)
	};
	/// RA
	typedef struct tagKERNEL
	{
		union {
			struct {
				s32	val[KERNEL_BOX_NUM];				//!< l
			};
			struct {
				s32	box[KERNEL_BOX_Y][KERNEL_BOX_X];	//!< l
			};
		};
	} KERNEL, *LPKERNEL;

	IRIS_STATIC_ASSERT( KERNEL_BOX_X & 0x1 );
	IRIS_STATIC_ASSERT( KERNEL_BOX_Y & 0x1 );
protected:
	LPKERNEL	m_pKernel[MAX_KERNEL];	//!< RA
public:
	// RXgN^
	CEdgeDetector(void);

public:
	// o
	bool	Detect(IImage* lpDst, const IImage* lpSrc, xf32 rate);
	// o
	bool	DetectFast(IImage* lpDst, const IImage* lpSrc, xf32 rate, void* lpWork, u32 WorkSize);

protected:
	// ZxvZ
	s32		Convolution(s32 x, s32 y, const IImage* lpSrc, LPKERNEL lpKernel);
public:
	/// RA̐ݒ
	void	SetKernel(s32 index, LPKERNEL pKernel)	{ IRIS_ASSERT( index >= 0 && index < MAX_KERNEL ); m_pKernel[index] = pKernel; }

public:
	// RAev[g
	/// Prewitt 
	typedef struct tagPREWITT_KERNEL_H : public tagKERNEL
	{
		tagPREWITT_KERNEL_H(void)
		{
			box[0][0] = 1; box[0][1] = 0; box[0][2] = -1;
			box[1][0] = 1; box[1][1] = 0; box[1][2] = -1;
			box[2][0] = 1; box[2][1] = 0; box[2][2] = -1;
		}
	} PREWITT_KERNEL_H;
	/// Prewitt 
	typedef struct tagPREWITT_KERNEL_V : public tagKERNEL
	{
		tagPREWITT_KERNEL_V(void)
		{
			box[0][0] =  1; box[0][1] =  1; box[0][2] =  1;
			box[1][0] =  0; box[1][1] =  0; box[1][2] =  0;
			box[2][0] = -1; box[2][1] = -1; box[2][2] = -1;
		}
	} PREWITT_KERNEL_V;

	/// Sobel 
	typedef struct tagSOBEL_KERNEL_H : public tagKERNEL
	{
		tagSOBEL_KERNEL_H(void)
		{
			box[0][0] = 1; box[0][1] = 0; box[0][2] = -1;
			box[1][0] = 2; box[1][1] = 0; box[1][2] = -2;
			box[2][0] = 1; box[2][1] = 0; box[2][2] = -1;
		}
	} SOBEL_KERNEL_H;
	/// Sobel 
	typedef struct tagSOBEL_KERNEL_V : public tagKERNEL
	{
		tagSOBEL_KERNEL_V(void)
		{
			box[0][0] =  1; box[0][1] =  2; box[0][2] =  1;
			box[1][0] =  0; box[1][1] =  0; box[1][2] =  0;
			box[2][0] = -1; box[2][1] = -2; box[2][2] = -1;
		}
	} SOBEL_KERNEL_V;

	/// Laplacian 4
	typedef struct tagLAPLACIAN4_KERNEL : public tagKERNEL
	{
		tagLAPLACIAN4_KERNEL(void)
		{
			box[0][0] =  0; box[0][1] = -1; box[0][2] =  0;
			box[1][0] = -1; box[1][1] =  4; box[1][2] = -1;
			box[2][0] =  0; box[2][1] = -1; box[2][2] =  0;
		}
	} LAPLACIAN4_KERNEL;

	/// Laplacian 8
	typedef struct tagLAPLACIAN8_KERNEL : public tagKERNEL
	{
		tagLAPLACIAN8_KERNEL(void)
		{
			box[0][0] = -1; box[0][1] = -1; box[0][2] = -1;
			box[1][0] = -1; box[1][1] =  8; box[1][2] = -1;
			box[2][0] = -1; box[2][1] = -1; box[2][2] = -1;
		}
	} LAPLACIAN8_KERNEL;
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
