//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndColorExchange.h
 * @brief		J[tH[}bgϊNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndColorExchange_H_
#define INCG_IRIS_FndColorExchange_H_

//======================================================================
// include
#include "FndImage.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// J[ϊe[uNX
class CColorExchange : public IIrisObject
{
public:
	typedef	void	(*PFN_COLOR_FORMAT_EXCHANGE)(u8* pDst, const u8* pSrc);
private:
	PFN_COLOR_FORMAT_EXCHANGE	m_pfnExchange;

public:
	/// RXgN^
	CColorExchange(void) : m_pfnExchange(func_nullptr) {}
	CColorExchange(PFN_COLOR_FORMAT_EXCHANGE pfn) : m_pfnExchange(pfn) {}

public:
	/// ֐s
	void	operator ()(u8* pDst, const u8* pSrc)	{ if( m_pfnExchange != nullptr ) (m_pfnExchange)(pDst, pSrc); }

public:
	// J[ϊ֐
	// RGBA8888 -> RGB888
	static	void		RGBA8_TO_RGB8		(u8* pDst, const u8* pSrc)	{ for(int i=0; i<3; ++i) pDst[i] = pSrc[i]; }
	// RGBA8888 -> RGBA8888
	static	void		RGBA8_TO_RGBA8		(u8* pDst, const u8* pSrc)	{ for(int i=0; i<4; ++i) pDst[i] = pSrc[i]; }
	// RGBA8888 -> RGBA4444
	static	void		RGBA8_TO_RGBA4		(u8* pDst, const u8* pSrc)	{ *(u16*)pDst = (u16)( (((pSrc[0]>>4) & 0xF)<<12) | (((pSrc[1]>>4) & 0xF)<<8) | (((pSrc[2]>>4) & 0xF)<<4) | (((pSrc[3]>>4) & 0xF)<<0) ); }
	// RGBA8888 -> RGBA5551
	static	void		RGBA8_TO_RGBA5551	(u8* pDst, const u8* pSrc)	{ *(u16*)pDst = (u16)( (((pSrc[0]>>3) & 0x1F)<<11) | (((pSrc[1]>>3) & 0x1F)<<6) | (((pSrc[2]>>3) & 0x1F)<<1) | ((pSrc[4] == 0) ? 0 : 1) ); }
	// RGBA8888 -> RGBA565
	static	void		RGBA8_TO_RGB565		(u8* pDst, const u8* pSrc)	{ *(u16*)pDst = (u16)( (((pSrc[0]>>3) & 0x1F)<<11) | (((pSrc[1]>>2) & 0x3F)<<6) | (((pSrc[2]>>3) & 0x1F)<<1) ); }
	// RGBA8888 -> L8
	static	void		RGBA8_TO_L8			(u8* pDst, const u8* pSrc)	{ int tmp = (u16)(pSrc[0]) + (u16)(pSrc[1]) + (u16)(pSrc[2]); *pDst = (u8)(tmp/3); }
	// RGBA8888 -> LA8
	static	void		RGBA8_TO_LA8		(u8* pDst, const u8* pSrc)	{ int tmp = (u16)(pSrc[0]) + (u16)(pSrc[1]) + (u16)(pSrc[2]); *pDst = (u8)(tmp/3); pDst[1] = pSrc[3]; }

	// RGBA8888 -> BGRA8888
	static	void		RGBA8_TO_BGRA8		(u8* pDst, const u8* pSrc)	{ u8 tmp = pSrc[0]; for( int i=1; i < 4; ++i ) pDst[i] = pSrc[i]; pDst[0] = pDst[2]; pDst[2] = tmp; }

public:
	// RGB888 -> RGB888
	static	void		RGB8_TO_RGB8		(u8* pDst, const u8* pSrc)	{ for(int i=0; i<3; ++i) pDst[i] = pSrc[i]; }
	// RGB888 -> RGBA8888
	static	void		RGB8_TO_RGBA8		(u8* pDst, const u8* pSrc)	{ for(int i=0; i<3; ++i) pDst[i] = pSrc[i]; pDst[3] = 0xFF; }
	// RGB888 -> RGBA4444
	static	void		RGB8_TO_RGBA4		(u8* pDst, const u8* pSrc)	{ *(u16*)pDst = (u16)( (((pSrc[0]>>4) & 0xF)<<12) | (((pSrc[1]>>4) & 0xF)<<8) | (((pSrc[2]>>4) & 0xF)<<4) | 0xF ); }
	// RGB888 -> RGBA5551
	static	void		RGB8_TO_RGBA5551	(u8* pDst, const u8* pSrc)	{ *(u16*)pDst = (u16)( (((pSrc[0]>>3) & 0x1F)<<11) | (((pSrc[1]>>3) & 0x1F)<<6) | (((pSrc[2]>>3) & 0x1F)<<1) | 1 ); }
	// RGB888 -> RGBA565
	static	void		RGB8_TO_RGB565		(u8* pDst, const u8* pSrc)	{ *(u16*)pDst = (u16)( (((pSrc[0]>>3) & 0x1F)<<11) | (((pSrc[1]>>2) & 0x3F)<<6) | (((pSrc[2]>>3) & 0x1F)<<1) ); }
	// RGB888 -> L8
	static	void		RGB8_TO_L8			(u8* pDst, const u8* pSrc)	{ int tmp = (u16)(pSrc[0]) + (u16)(pSrc[1]) + (u16)(pSrc[2]); *pDst = (u8)(tmp/3); }
	// RGB888 -> LA8
	static	void		RGB8_TO_LA8			(u8* pDst, const u8* pSrc)	{ int tmp = (u16)(pSrc[0]) + (u16)(pSrc[1]) + (u16)(pSrc[2]); *pDst = (u8)(tmp/3); pDst[1] = 0xFF; }

	// RGB888 -> BGRA8888
	static	void		RGB8_TO_BGRA8		(u8* pDst, const u8* pSrc)	{ for( int i=0; i < 3; ++i ) pDst[2-i] = pSrc[i]; pDst[3] = 0xFF; }

public:
	// BGRA8888 -> RGBA8888
	static	void		BGRA8_TO_RGBA8		(u8* pDst, const u8* pSrc)	{ u8 tmp = pSrc[0]; for( int i=1; i < 4; ++i ) pDst[i] = pSrc[i]; pDst[0] = pDst[2]; pDst[2] = tmp; }
	// BGRA8888 -> RGB888
	static	void		BGRA8_TO_RGB8		(u8* pDst, const u8* pSrc)	{for( int i=0; i < 3; ++i ) pDst[2-i] = pSrc[i]; }

public:
	// Fϊ֐̎擾
	static	PFN_COLOR_FORMAT_EXCHANGE		GetColorFormatExchange(int nSrcPixelFormat, int* lpSrcSize, int nDstPixelFormat, int* lpDstSize)
	{
		struct _info { PFN_COLOR_FORMAT_EXCHANGE pfn; int src_size; int dst_size; };
		static const _info list[IImage::PF_NUM][IImage::PF_NUM] = {
			{
				{ RGBA8_TO_RGBA8	, 4, 4 },
				{ RGBA8_TO_RGB8		, 4, 3 },
				{ RGBA8_TO_RGBA4	, 4, 4 },
				{ RGBA8_TO_RGBA5551	, 4, 4 },
				{ RGBA8_TO_RGB565	, 4, 4 },
				{ RGBA8_TO_L8		, 4, 1 },
				{ RGBA8_TO_LA8		, 4, 2 },
			},
			{
				{ RGB8_TO_RGBA8		, 3, 4 },
				{ RGB8_TO_RGB8		, 3, 3 },
				{ RGB8_TO_RGBA4		, 3, 4 },
				{ RGB8_TO_RGBA5551	, 3, 4 },
				{ RGB8_TO_RGB565	, 3, 4 },
				{ RGB8_TO_L8		, 3, 1 },
				{ RGB8_TO_LA8		, 3, 2 },
			}
		};
		const _info& info = list[nSrcPixelFormat][nDstPixelFormat];
		if( lpSrcSize != nullptr )	*lpSrcSize = info.src_size;
		if( lpDstSize != nullptr )	*lpDstSize = info.dst_size;
		return info.pfn;
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
