//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSHA256.cpp
 * @brief		SHA256 NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndSHA256_CPP_

//======================================================================
// include
#include "FndSHA256.h"

namespace iris {
namespace fnd
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSHA256::CSHA256(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSHA256::~CSHA256(void)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CSHA256::Init(void)
{
	math::SHA256InitContext(&m_Context);
}

/**********************************************************************//**
 *
 * NA
 *
*//***********************************************************************/
void CSHA256::Clear(void)
{
	math::SHA256ClearContext(&m_Context);
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@
*//***********************************************************************/
void CSHA256::Update(const u8* lpBuffer, size_t uLength)
{
	math::SHA256Update(&m_Context, lpBuffer, uLength);
}

/**********************************************************************//**
 *
 * ŏIXV
 *
*//***********************************************************************/
void CSHA256::Final(void)
{
	math::SHA256Final(&m_Context);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
*//***********************************************************************/
void CSHA256::Output(u8* lpBuffer)	const
{
	math::SHA256Output(&m_Context, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void CSHA256::ToStringA(LPSTR  lpString, size_t uSize, u8* lpBuffer)	const
{
	math::SHA256ToStringA(lpString, uSize, lpBuffer);
}
void CSHA256::ToStringW(LPWSTR lpString, size_t uSize, u8* lpBuffer)	const
{
	math::SHA256ToStringW(lpString, uSize, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void CSHA256::ToStringA(LPSTR  lpString, size_t uSize)	const
{
	_ToStringA<HASHSIZE>(lpString, uSize);
}
void CSHA256::ToStringW(LPWSTR lpString, size_t uSize)	const
{
	_ToStringW<HASHSIZE>(lpString, uSize);
}

}	// end of namespace fnd
}	// end of namespace iris

#if	defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../unit/gt/gt_inchead.h"
#include "../../iris_using.h"

TEST(CFndSHA256Test, Function)
{
	char comm[256] = "";
	CSHA256 sha;

	// TEST1
	strcpy_s(comm, 256, "abc");
	sha.Encode(comm, strlen(comm));
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"ba7816bf8f01cfea"
		"414140de5dae2223b00361a396177a9cb410ff61f20015ad"
		, comm );

	// TEST2
	strcpy_s(comm, 256, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq");
	sha.Encode(comm, strlen(comm));
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"248d6a61d20638b8"
        "e5c026930c3e6039a33ce45964ff2167f6ecedd419db06c1"
		, comm );

	// TEST3
	strcpy_s(comm, 256, "a");
	sha.Init();
	for( int i=0; i < 1000000; ++i )
		sha.Update((const u8*)comm, strlen(comm));
	sha.Final();
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"cdc76e5c9914fb92"
        "81a1c7e284d73e67f1809a48a497200e046d39ccc7112cd0"
		, comm );

	// TEST4
	strcpy_s(comm, 256, "01234567012345670123456701234567""01234567012345670123456701234567");
	sha.Init();
	for( int i=0; i < 10; ++i )
		sha.Update((const u8*)comm, strlen(comm));
	sha.Final();
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"594847328451bdfa"
        "85056225462cc1d867d877fb388df0ce35f25ab5562bfbb5"
		, comm );
}

#endif	// #if	defined(_IRIS_SUPPORT_GOOGLETEST)

