//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSHA.h
 * @brief		SHA NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSHA_H_
#define INCG_IRIS_FndSHA_H_

//======================================================================
// include
#include "FndSHA1.h"
#include "FndSHA160.h"
#include "FndSHA224.h"
#include "FndSHA256.h"
#include "FndSHA384.h"
#include "FndSHA512.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// SHA nbVNX
template<int SHA>
class CSHA : public IIrisObject
{
	template<int N>
	struct _selector {};

	template<>
	struct _selector<1>
	{
		typedef CSHA1	type;
	};
	template<>
	struct _selector<160>
	{
		typedef CSHA160	type;
	};
	template<>
	struct _selector<224>
	{
		typedef CSHA224	type;
	};
	template<>
	struct _selector<256>
	{
		typedef CSHA256	type;
	};
	template<>
	struct _selector<384>
	{
		typedef CSHA384	type;
	};
	template<>
	struct _selector<512>
	{
		typedef CSHA512	type;
	};

public:
	typedef typename _selector<SHA>::type	type;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
