//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndHash.h
 * @brief		Hash C^[tFCX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndHash_H_
#define INCG_IRIS_FndHash_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// nbVC^[tFCXNX
class IHash : public IIrisObject
{
public:
	/// fXgN^
	virtual ~IHash(void) {}

public:
	/// 
	virtual void	Init(void)	= 0;
	/// NA
	virtual void	Clear(void)	= 0;
	/// XV
	virtual void	Update(const u8* lpBuffer, size_t uLength)	= 0;
	/// ŏIXV
	virtual void	Final(void)	= 0;
	/// nbV̏o
	virtual void	Output(u8* lpBuffer) const	= 0;
	/// nbVobt@當o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize, u8* lpHashBuffer)	const = 0;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize, u8* lpHashBuffer)	const = 0;
	/// o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize) const	= 0;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize) const	= 0;
	/// nbVTCY̎擾
	virtual u32		GetHashSize(void)	const	= 0;

public:
	/// nbVobt@當o
	void	ToString (LPTSTR lpString, size_t uSize, u8* lpHashBuffer) const
	{
#ifdef UNICODE
		ToStringW(lpString, uSize, lpHashBuffer);
#else
		ToStringA(lpString, uSize, lpHashBuffer);
#endif
	}
	/// o
	void	ToString (LPTSTR lpString, size_t uSize) const
	{
#ifdef UNICODE
		ToStringW(lpString, uSize);
#else
		ToStringA(lpString, uSize);
#endif
	}
	/// ꊇvZ
	void	Encode(const u8* lpBuffer, size_t uLength)
	{
		Clear();
		Init();
		Update(lpBuffer, uLength);
		Final();
	}

public:
	template<typename _TN>
	void	Update(const _TN* lpBuffer, size_t uLength)
	{
		Update(reinterpret_cast<const u8*>(lpBuffer), uLength);
	}
	template<typename _TN>
	void	Output(const _TN* lpBuffer)	const
	{
		Output(reinterpret_cast<const u8*>(lpBuffer));
	}
	/// ꊇvZ
	template<typename _TN>
	void	Encode(const _TN* lpBuffer, size_t uLength)
	{
		Encode(reinterpret_cast<const u8*>(lpBuffer), uLength);
	}

protected:
	template<int SIZE>
	void	_ToStringA(LPSTR  lpString, size_t uSize)	const
	{
		IRIS_STATIC_ASSERT(SIZE > 0);
		u8 output[SIZE];
		Output(output);
		ToStringA(lpString, uSize, output);
	}
	template<int SIZE>
	void	_ToStringW(LPWSTR lpString, size_t uSize)	const
	{
		IRIS_STATIC_ASSERT(SIZE > 0);
		u8 output[SIZE];
		Output(output);
		ToStringW(lpString, uSize, output);
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
