//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndUnitTest.cpp
 * @brief		P̃eXgt@Ct@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndUnitTest_CPP_

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

//======================================================================
// include
#include "../../unit/UnitCore.h"
// wb_݂̂̃t@Cincludeă`FbN
#include "../../cipher/FndAES.h"
#include "../FndAllocator.h"
#include "../FndArray.h"
#include "../FndAspect.h"
#include "../FndAspectMT.h"
#include "../FndAutoPtr.h"
#include "../FndAutoSingleton.h"
#include "../FndAVLTree.h"
#include "../FndLiberator.h"
#include "../FndList.h"
#include "../FndLonePtr.h"
#include "../FndOrderedTree.h"
#include "../FndQueue.h"
#include "../FndRange.h"
#include "../FndRedBlackTree.h"
#include "../FndRefPtr.h"
#include "../FndRegexOp.h"
#include "../FndScopedLock.h"
#include "../FndScopedPtr.h"
#include "../FndSealed.h"
#include "../FndSingleton.h"
#include "../FndSort.h"
#include "../FndVector.h"
#include "../../types/FndCollector.h"
#include "../../types/FndDelayVariable.h"
#include "../../types/FndExecutor.h"
#include "../../types/FndFuzzyVariable.h"
#include "../../types/FndLargeVariable.h"
#include "../../types/FndSyncObject.h"
#include "../../types/FndTypes.h"
#include "../../types/FndVLVariable.h"
#include "../../utility/FndDPI.h"
#include "../../utility/FndFlag.h"
#include "../../utility/FndRefCounter.h"
#include "../../utility/FndUID.h"
#include "../../utility/FndByteArrayIOStream.h"
#include "../../random/FndRandom.h"
#include <time.h>
#include "../../../iris_using.h"
#include "../../../iris_iostream.h"

#if	defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../../unit/gt/gt_inchead.h"
#include <map>

TEST(ContainerTest, Range)
{
	typedef CRange<int>					Range;
	Range range0(  0, 100);
	Range range1(100, 200);
	Range range2(195, 300);

	{
		typedef std::multimap<Range, int>	MAP;
		typedef std::pair<Range, int>		PAIR;

		MAP	map;
		map.insert(PAIR(range0, 0));
		map.insert(PAIR(range1, 1));
		map.insert(PAIR(range2, 2));

		size_t cnt = map.count(Range(50, 150));			// }b`L[̐擾
		MAP::iterator it = map.find(Range(50, 150));	// 
		ASSERT_TRUE( it != map.end() );
		ASSERT_EQ( 2, cnt );	// }b`L[̌eXg
		// z肳 value Ă邩̃eXg
		for( size_t i=0; i < cnt; ++i, ++it )
		{
			ASSERT_EQ( it->second, 0+i );
		}
	}

#if	defined(IRIS_MFC_VER)
	{
		typedef CMap<Range, Range&, int, int&>	MAP;

		MAP map;
	}
#endif
}

TEST(ContainerTest, List)
{
	typedef CListNode<int>		myNode;
	typedef CList<myNode>		myList;
	myList	list;
	int find = 0;
	ASSERT_EQ( 0, list.size() );
	ASSERT_EQ( TRUE, list.find(find) == nullptr );
	myNode node[10];
	for( int i=0; i < 10; ++i )
	{
		node[i].set(i);
		list.push_back(node+i);
	}
	ASSERT_EQ( 10, list.size() );
	ASSERT_EQ( 0, *(*list.find(find)) );
}

TEST(ContainerTest, Queue)
{
	typedef CDelayVariable<xf32>		CF32Delay;
	typedef CQueue<CF32Delay*, 32>		myQueue;
	myQueue	queue;
	CF32Delay	d;
	queue.push(&d);
	ASSERT_FALSE( queue.empty() );
	ASSERT_EQ( 32, queue.capacity() );
	ASSERT_EQ( 1, queue.size() );
	CF32Delay* g = queue.get(0);
	queue.pop();
	ASSERT_EQ( &d, g );
}

#endif

//======================================================================
// declare
static void __AspectTest(void);
static void	__ArrayTest(void);
static void	__AVLTreeTest(void);
static void	__RedBlackTreeTest(void);

//======================================================================
// typedef
typedef CDelayVariable<xf32>		CF32Delay;

//======================================================================
// test
IRIS_UNITTEST(Ctest_templateUnitTest, FndUnitTest)
{
	typedef CListNode<int>			Node;
	typedef CList<Node>				List;
	typedef CFixedAllocator<List,1>	FixAlloc;
	typedef CLonePtr<List,FixAlloc>	Lone;
	typedef CRefPtr<List>			Ref;
	CAutoPtr<int> aptr(new int);
	CScopedPtr<int*> sptr(new int);

	__AspectTest();

	Lone lone = new List;
	Ref ref = new List;

	{
		typedef COrderedTreeNode<CF32Delay>	OTreeNode;
		typedef COrderedTree<OTreeNode>		OTree;
		CF32Delay	d;
		OTreeNode	node(&d);
		OTree		tree;
		tree.push_child(&node);
		IRIS_ASSERT( !tree.empty() );
		for( OTree::iterator it = tree.begin(); it != tree.end(); ++it )
		{
		}
		tree.clear();
	}

	__AVLTreeTest();
	__RedBlackTreeTest();

	__ArrayTest();
}

static void __AspectTest(void)
{
	typedef CAspectual< CF32Delay*, CLogAspect<CF32Delay*> > CF32DelayAspect;
	typedef CAspectual< CF32Delay*, CLogAspect<CF32Delay*, CLogAspect<CF32Delay*> > > CF32DelayAspect2;
	CF32Delay d;
	CF32DelayAspect da(&d);
	CF32DelayAspect2 da2 = &d;
	da->Update();
	da2->Update();
}

static void __ArrayTest(void)
{
	typedef CArray<CF32Delay>			Array;
	typedef CRingArray<CF32Delay>		RingArray;

	{
		typedef CFixedArray<CF32Delay,5>	a1;
		typedef CFixedArray<int,5>			b1;
		int i=0;
		a1 a;
		i=0;
		for( a1::iterator it = a.begin(), end = a.end(); it != end; ++it, ++i )
		{
			*it = XF32_ONE;
			IRIS_ASSERT(*it == a[i]);
		}
		b1 b;
		i=0;
		for( b1::iterator it = b.begin(), end = b.end(); it != end; ++it, ++i )
		{
			*it = 0;
			IRIS_ASSERT(*it == b[i]);
		}
	}
	{
		Array a(10);
		Array b;
		a[0] = XF32_ONE;
		b = a;
		b.resize(2);
		Array::value_type x = b[1];
	}
	{
		RingArray a(10);
		RingArray b;
		a[0] = XF32_ONE;
		b = a;
		b.resize(9);
		IRIS_ASSERT( b[0] == b[9] );
	}
}

static void	__AVLTreeTest(void)
{
	printf("test AVL Tree.\n");
	typedef CF32Delay					AVLNodeType;
	typedef CAVLTreeNode<AVLNodeType>	AVLTreeNode;
	typedef CAVLTree<AVLTreeNode>		AVLTree;
	AVLNodeType	d1(XF32_ONE), d2(XF32_ZERO), d3(XF32_HALF);
	AVLTreeNode	node1(d1);
	AVLTreeNode	node2(d2);
	AVLTreeNode	node3(d3);
	AVLTree		tree;
	tree.insert(&node1);
	tree.insert(&node2);
	tree.insert(&node3);
	tree.print();
	tree.erase(&node3);
	tree.print();
	tree.erase(&node2);
	tree.print();
}

static void	__RedBlackTreeTest(void)
{
#ifdef WIN32
	CRandom::GetInstance().Initialize((u32)time(nullptr));
#else
	CRandom::GetInstance().Initialize(0);
#endif

	printf("test Red-Black Tree.\n");
	typedef CRBTreeNode<CF32Delay>	RBTreeNode;
	typedef CRBTree<RBTreeNode>		RBTree;

	const static int node_num = 7;
	xf32 tbl[] = {
		XF32_CONST(0.0f),
		XF32_CONST(1.0f),
		XF32_CONST(0.5f),
		XF32_CONST(0.3f),
		XF32_CONST(0.1f),
		XF32_CONST(1.1f),
		XF32_CONST(1.5f),
	};
	int tbl_num = sizeof(tbl)/sizeof(tbl[0]);
	CF32Delay	d[node_num];
	RBTreeNode	node[node_num];
	RBTree	tree;
	for( int i=0; i < node_num; ++i )
	{
		d[i] = tbl[i%tbl_num];
		node[i].set(d[i]);
		tree.insert(&node[i]);
#ifdef _IRIS_DEBUG
		tree.print();
#endif
	}
	for( int i=1; i < node_num; ++i )
	{
#if 1
		RBTree::value_ptr root = tree.root();
		for(RBTree::iterator it = tree.begin(), end = tree.end(); it != end; ++it) 
		{
			RBTree::iterator tmp = it;
			++tmp;
			if( tmp != end )
			{
				--tmp;
				IRIS_ASSERT( tmp == it );
			}
			if( it != root && it->m_Color == RBTreeNode::BLACK )
			{
				tree.erase(it);
				tree.print();
				break;
			}
		}
#else
		int idx = RandS32() % node_num;
		while( 1 )
		{
			if( tree.search(node[idx]) != nullptr )
			{
				printf( " -->>!! delete %0.8x.\n", (u32)(u32w64)&node[idx] );
				tree.erase(&node[idx]);
				tree.print();
				break;
			}
			++idx;
			idx %= node_num;
		}
#endif
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )
