//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndVector.h
 * @brief		vectorNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndVector_H_
#define INCG_IRIS_FndVector_H_

//======================================================================
// include
#include "FndList.h"
#include "FndAllocator.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief vectorNX
 * @tparam	_TN			= Ώی^
 * @tparam	_Allocator	= AP[^^Cv
*/
template< typename _TN, class _Allocator=CNewAllocator<_TN> >
class CVector : public INonCopyable<>
{
public:
	typedef	_TN		value_type;
	typedef	_TN*	value_ptr;
	typedef	_TN&	value_ref;

	typedef	const _TN*	const_ptr;
	typedef	const _TN&	const_ref;

private:
	// nodeNX
	class CNode : public CListNodeBase
	{
	private:
		value_type	m_val;	//!< l
	public:
		/// RXgN^
		explicit CNode(const_ref val) : m_val(val) {}
		/// RXgN^
		CNode(void) {}
		// Iy[^
		value_ref operator * ()			{ return m_val; }
		const_ref operator * () const	{ return m_val; }
		operator value_type () const	{ return m_val; }

		CNode&			operator =  (const_ref val)			{ this->m_val = val; return *this; }
		s32				operator == (const_ref val) const	{ return this->m_val == val; }
		s32				operator != (const_ref val) const	{ return this->m_val != val; }
		s32				operator <  (const_ref val) const	{ return this->m_val <  val; }
		s32				operator <= (const_ref val) const	{ return this->m_val <= val; }
		s32				operator >  (const_ref val) const	{ return this->m_val >  val; }
		s32				operator >= (const_ref val) const	{ return this->m_val >= val; }

		CNode&			operator =  (const CNode& rhs)			{ this->m_val = rhs.m_val; return *this; }
		s32				operator == (const CNode& rhs) const	{ return this->m_val == rhs.m_val; }
		s32				operator != (const CNode& rhs) const	{ return this->m_val != rhs.m_val; }
		s32				operator <  (const CNode& rhs) const	{ return this->m_val <  rhs.m_val; }
		s32				operator <= (const CNode& rhs) const	{ return this->m_val <= rhs.m_val; }
		s32				operator >  (const CNode& rhs) const	{ return this->m_val >  rhs.m_val; }
		s32				operator >= (const CNode& rhs) const	{ return this->m_val >= rhs.m_val; }

		/// l擾
		value_ref		get(void)				{ return m_val; }
		const_ref		get(void) const			{ return m_val; }
		/// l̐ݒ
		void			set(const_ref val)		{ m_val = val; }
	};

private:
	// list
	typedef CList<CNode>	_vector;
	// allocator
	typedef typename _Allocator::template rebind<CNode>::other allocator_type;

public:
	typedef	typename _vector::iterator			iterator;
	typedef	typename _vector::const_iterator	const_iterator;

protected:
	_vector	m_list;	//!< Xg

public:
	/// fXgN^
	~CVector(void) { clear(); }
public:
	value_ref		operator [] (int pos)			{ return m_list[pos]->get(); }
	const_ref		operator [] (int pos)	const	{ return m_list[pos]->get(); }

public:
	/// 擪̃Ce[^擾
	iterator 		begin(void)			{ return m_list.begin(); }
	const_iterator	begin(void) const	{ return m_list.begin(); }
	
	/// I[̃Ce[^擾
	iterator		end(void)			{ return m_list.end(); }
	const_iterator	end(void) const		{ return m_list.end(); }
	
	/// 擪̃m[h擾
	value_ref		front(void)			{ return m_list.front()->get(); }
	const_ref		front(void) const	{ return m_list.front()->get(); }
	
	/// I[̃m[h擾
	value_ref		back(void)			{ return m_list.back()->get(); }
	const_ref		back(void) const	{ return m_list.back()->get(); }
	
	/**
	 * @brief ۂǂ
	 * @retval	true	= 
	*/
	bool			empty(void) const	{ return m_list.empty(); }

	/**
	 * @brief w͈͂폜
	 * @param [in]	first	= 폜Ce[^̐擪
	 * @param [in]	last	= 폜Ce[^̏I[
	 * @return	폜݂̌̈ʒu
	*/
	iterator		erase(iterator first, iterator last)
	{
		while(first != last) { erase(first++); }
		return last;
	}

	/**
	 * @brief 폜
	 * @param [in]	pos	= 폜Ce[^
	*/
	iterator		erase(iterator pos)	
	{ 
		CNode* node = &pos;
		iterator it = m_list.erase(pos);
		allocator().dealloc(node);
		return it;
	}

	/// S폜
	void			clear(void)		{ erase(begin(), end()); }

	/**
	 * @brief }
	 * @param [in]	pos	= }ʒu
	 * @param [in]	val	= }l
	*/
	void			insert(iterator pos, const_ref val)
	{
		CNode* node = (CNode*)allocator().alloc();
		IRIS_ASSERT( node != nullptr );
		node->set(val);
		m_list.insert(pos, node);
	}

	/**
	 * @brief 擪ɓo^
	 * @param [in]	val	= o^m[h|C^
	*/
	void			push_front(const_ref val)		{ insert(begin(), val); }
	
	/// 擪폜
	void			pop_front(void)					{ erase(begin()); }

	/**
	 * @brief I[ɓo^
	 * @param [in]	val	= o^m[h|C^
	*/
	void			push_back(const_ref val)		{ insert(end(), val); }
	
	/// I[擾
	void			pop_back(void)					{ iterator it=end(); erase(--it); }

	/**
	 * @brief o^擾
	 * @return	o^
	*/
	s32				size(void) const				{ return m_list.size(); }

	/**
	 * @brief TCY̕ύX
	 * @param [in] size = ύX̃TCY
	*/
	void			resize(s32 nSize)
	{
		s32 i=size();
		if( i > nSize )
		{
			erase(m_list[nSize], end());
			return;
		}

		for( ; i < nSize; ++i )
		{
			CNode* node = reinterpret_cast<CNode*>(allocator().alloc());
			IRIS_ASSERT( node != nullptr );
			m_list.push_back(node);
		}
	}

public:
	/**
	 * @brief \[gđ}
	 * @param [in]	val	= }m[h|C^
	*/
	void			sort_insert(const_ref val)		{ sortinsert(val, CLessOp()); }

	/**
	 * @brief \[gđ}
	 * @param [in]	val		= }m[h|C^
	 * @param [in]	func	= r֐IuWFNg
	*/
	template<typename Func>
	void			sort_insert(const_ref value, const Func& func)
	{
		CNode* node = allocator().alloc();
		IRIS_ASSERT( node != nullptr );
		node->set(value);
		m_list.sort_insert(node, func);
	}

	/**
	 * @brief SĂiteratorFuncs
	 * @param [in]	func	= s֐IuWFNg
	*/
	template<typename Func>
	void			foreach(Func func)			{ m_list.foreach(func); }

	/**
	 * @brief 
	 * @param [in]	val		= Ώ
	*/
	iterator		find(const_ref val)	const	{ return m_list.find(val); }

	/**
	 * @brief 
	 * @param [in]	val		= Ώ
	 * @param [in]	func	= r֐IuWFNg
	*/
	template<typename Func>
	iterator		find(const_ref val, const Func& func)	const	{ return m_list.find(val, func); }

	/**
	 * @brief 
	 * @param [in]	pos		= Jnʒu
	 * @param [in]	val		= Ώ
	 * @param [in]	func	= r֐IuWFNg
	*/
	template<typename Func>
	iterator		find(const_iterator pos, const_ref val, const Func& func)	const	{ return m_list.find(pos, val, func); }

	/// \[g
	void			sort(void)					{ m_list.sort(CLessOp()); }

	/**
	 * @brief \[g
	 * @param [in]	func	= r֐IuWFNg
	*/
	template <typename Func>
	void			sort(const Func& func)		{ m_list.sort(func); }

private:
	static allocator_type& allocator( void ) 
	{
		static allocator_type	this_allocator;
		return this_allocator;
	}
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
