//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndVaugeOperator.h
 * @brief		B operator IuWFNgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndVaugeOperator_H_
#define INCG_IRIS_FndVaugeOperator_H_

//======================================================================
// include
#include "FndOperator.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CVaugeOp;			// ɞB
class CVaugeFalseOp;	// ɋU
class CVaugeTrueOp;		// ɐ^
class CVaugeEqualOp;	// ==
class CVaugeLessOp;		// <
class CVaugeLEqualOp;	// <=
class CVaugeGreaterOp;	// >
class CVaugeGEqualOp;	// >=
class CVaugeNotEqualOp;	// !=

//======================================================================
// class
//! false operator IuWFNg
class CVaugeFalseOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const 
	{
		IRIS_UNUSED_VARIABLE(lhs);
		IRIS_UNUSED_VARIABLE(rhs);
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return IrisVaugeBool::VB_FALSE;
	}

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append		{ typedef _TN			other; };
	// operatorperator폜
	template<typename _TN>struct erase		{ typedef CVaugeFalseOp	other; };
	// ΂̐operator
	typedef CVaugeTrueOp		opposite;
};

//! true operator IuWFNg
class CVaugeTrueOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const 
	{
		IRIS_UNUSED_VARIABLE(lhs);
		IRIS_UNUSED_VARIABLE(rhs);
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return IrisVaugeBool::VB_TRUE;
	}

private:
	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl		{ typedef typename _TN::opposite	other; };
	template<class _TC>struct erase_impl<_TC, _TC>			{ typedef CVaugeFalseOp				other; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append		{ typedef _TN		other; };
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeTrueOp, _TN>::other	other;
	};
	// ΂̐operator
	typedef CVaugeFalseOp	opposite;
};

//! == operator IuWFNg
class CVaugeEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const 
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs == rhs ? IrisVaugeBool::VB_TRUE : IrisVaugeBool::VB_FALSE; 
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl				{ typedef _TN		other; };
	template<class _TC>struct append_impl<_TC, CVaugeLessOp>		{ typedef CVaugeLEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeGreaterOp>		{ typedef CVaugeGEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeNotEqualOp>	{ typedef CVaugeTrueOp	other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC			other; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp	other; };
	template<class _TC>struct erase_impl<_TC, CVaugeGEqualOp>	{ typedef CVaugeFalseOp	other; };
	template<class _TC>struct erase_impl<_TC, CVaugeLEqualOp>	{ typedef CVaugeFalseOp	other; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp	other; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeEqualOp, _TN>::other	other;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeEqualOp, _TN>::other	other;
	};
	// ΂̐operator
	typedef CVaugeNotEqualOp	opposite;
};

//! < operator IuWFNg
class CVaugeLessOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const 
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs < rhs ? IrisVaugeBool::VB_TRUE : (lhs > rhs ? IrisVaugeBool::VB_FALSE : IrisVaugeBool::VB_VAUGE); 
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl				{ typedef _TN				other; };
	template<class _TC>struct append_impl<_TC, CVaugeEqualOp>		{ typedef CVaugeLEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeGreaterOp>		{ typedef CVaugeNotEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeGEqualOp>		{ typedef CVaugeTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CVaugeNotEqualOp>	{ typedef _TC				other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC				other; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CVaugeLEqualOp>	{ typedef CVaugeFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CVaugeNotEqualOp>	{ typedef typename append_impl<_TC, CVaugeEqualOp>::other	other; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp		other; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeLessOp, _TN>::other	other;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeLessOp, _TN>::other	other;
	};
	// ΂̐operator
	typedef CVaugeGEqualOp	opposite;
};

//! <= operator IuWFNg
class CVaugeLEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs <= rhs ? IrisVaugeBool::VB_TRUE : IrisVaugeBool::VB_FALSE; 
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl				{ typedef _TN				other; };
	template<class _TC>struct append_impl<_TC, CVaugeEqualOp>		{ typedef CVaugeLEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeLessOp>		{ typedef CVaugeLEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeGreaterOp>		{ typedef CVaugeTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CVaugeGEqualOp>		{ typedef CVaugeTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CVaugeNotEqualOp>	{ typedef CVaugeLessOp		other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC				other; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CVaugeEqualOp>	{ typedef CVaugeLessOp		other; };
	template<class _TC>struct erase_impl<_TC, CVaugeLessOp>		{ typedef CVaugeEqualOp		other; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp		other; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeLEqualOp, _TN>::other	other;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeLEqualOp, _TN>::other		other;
	};
	// ΂̐operator
	typedef CVaugeGreaterOp	opposite;
};

//! > operator IuWFNg
class CVaugeGreaterOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const 
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs > rhs ? IrisVaugeBool::VB_TRUE : (lhs < rhs ? IrisVaugeBool::VB_FALSE : IrisVaugeBool::VB_VAUGE); 
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl				{ typedef _TN				other; };
	template<class _TC>struct append_impl<_TC, CVaugeEqualOp>		{ typedef CVaugeGEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeLessOp>		{ typedef CVaugeNotEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeLEqualOp>		{ typedef CVaugeTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CVaugeNotEqualOp>	{ typedef CVaugeGreaterOp	other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC				other; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CVaugeGEqualOp>	{ typedef CVaugeFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CVaugeNotEqualOp>	{ typedef typename append_impl<_TC, CVaugeEqualOp>::other	other; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp		other; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeGreaterOp, _TN>::other	other;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeGreaterOp, _TN>::other	other;
	};
	// ΂̐operator
	typedef CVaugeLEqualOp	opposite;
};

//! >= operator IuWFNg
class CVaugeGEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs >= rhs ? IrisVaugeBool::VB_TRUE : IrisVaugeBool::VB_FALSE; 
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl				{ typedef _TN				other; };
	template<class _TC>struct append_impl<_TC, CVaugeEqualOp>		{ typedef CVaugeGEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeLessOp>		{ typedef CVaugeTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CVaugeLEqualOp>		{ typedef CVaugeTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CVaugeGreaterOp>		{ typedef CVaugeGEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeNotEqualOp>	{ typedef CVaugeGreaterOp	other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC				other; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CVaugeEqualOp>	{ typedef CVaugeGreaterOp	other; };
	template<class _TC>struct erase_impl<_TC, CVaugeGreaterOp>	{ typedef CVaugeEqualOp		other; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp		other; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeGEqualOp, _TN>::other	other;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeGEqualOp, _TN>::other		other;
	};
	// ΂̐operator
	typedef CVaugeLessOp	opposite;
};

//! != operator IuWFNg
class CVaugeNotEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs != rhs ? IrisVaugeBool::VB_TRUE : IrisVaugeBool::VB_FALSE;
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl			{ typedef _TN				other; };
	template<class _TC>struct append_impl<_TC, CVaugeEqualOp>	{ typedef CVaugeTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CVaugeGEqualOp>	{ typedef CVaugeGreaterOp	other; };
	template<class _TC>struct append_impl<_TC, CVaugeLEqualOp>	{ typedef CVaugeLessOp		other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC				other; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp		other; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeNotEqualOp, _TN>::other	other;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeNotEqualOp, _TN>::other	other;
	};
	// ΂̐operator
	typedef CVaugeEqualOp	opposite;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
