//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndTemplateNode.h
 * @brief		؍\NXtemplatem[hNXx[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndTemplateNode_H_
#define INCG_IRIS_FndTemplateNode_H_

//======================================================================
// include
#include "FndLiberator.h"
#include "../../c++0x/cpp0x_type_traits.hpp"
#include "../../ml/iml_type_select.hpp"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	؍\NXtemplatem[hx[X
 * @tparam	_TN			= Ώی^
 * @tparam	_NodeBase	= m[h^
*/
template< typename _TN, class _NodeBase >
class CTemplateNode : public _NodeBase
{
	typedef CTemplateNode<_TN, _NodeBase>	_Myt;
public:
	typedef	_TN		value_type;
	typedef	_TN*	value_ptr;
	typedef	_TN&	value_ref;
	typedef const _TN&	const_ref;
	typedef typename ::iml::type_select< ::cpp0x::is_scalar<_TN>::value, _TN, const _TN& >::type arg_type;	//!< ^
private:
	value_type	m_value;
public:
	/// RXgN^
	CTemplateNode(arg_type val) : m_value(val)	{}
	/// RXgN^
	CTemplateNode(void)	: m_value(0)		{}
	/// fXgN^
	virtual ~CTemplateNode(void)	{}
	
	// Iy[^
	value_ref		operator *	()			{ return m_value; }
	const_ref		operator *	() const	{ return m_value; }
	value_type		operator -> () const	{ return m_value; }

	bool			operator == (const _TN&  rhs) const	{ return m_value == rhs; }
	bool			operator == (const _Myt& rhs) const	{ return m_value == *rhs; }
	bool			operator != (const _Myt& rhs) const	{ return m_value != *rhs; }
	bool			operator <  (const _Myt& rhs) const	{ return m_value <  *rhs; }
	bool			operator <= (const _Myt& rhs) const	{ return m_value <= *rhs; }
	bool			operator >  (const _Myt& rhs) const	{ return m_value >  *rhs; }
	bool			operator >= (const _Myt& rhs) const	{ return m_value >= *rhs; }
	_Myt&			operator =  (arg_type  rhs)   const	{ m_value = rhs; return *this; }

	/// l擾
	value_ref		value(void)					{ return m_value; }
	const_ref		value(void)	const			{ return m_value; }
	/// |C^̐ݒ(Nς݂̃m[h͑łȂ)
	void			set(arg_type val)			{ IRIS_ASSERT(!this->is_link()); m_value = val; }
};

/**
 * @brief	؍\NXtemplatem[hx[X(Liberatort)
 * @tparam	_TN			= Ώی^
 * @tparam	_NodeBase	= m[h^
 * @tparam	_Liberator	= NX^
*/
template< typename _TN, class _NodeBase, class _Liberator=CLiberatorObject<_TN> >
class CTemplateLiberateNode : public _NodeBase, public _Liberator
{
	typedef CTemplateLiberateNode<_TN, _NodeBase, _Liberator>	_Myt;
public:
	typedef	_TN		value_type;
	typedef	_TN*	value_ptr;
	typedef	_TN&	value_ref;
public:
	/// RXgN^
	explicit CTemplateLiberateNode(value_ptr p) : _Liberator(p)	{}
	/// RXgN^
	CTemplateLiberateNode(void)	: _Liberator(nullptr)		{}
	/// fXgN^
	virtual ~CTemplateLiberateNode(void)	{ this->liberate(); }
	
	// Iy[^
	value_ref		operator *	() const	{ return *(static_cast<value_ptr>(this->m_ptr)); }
	value_ptr		operator -> () const	{ return static_cast<value_ptr>(this->m_ptr); }

	bool			operator == (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) == *rhs; }
	bool			operator != (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) != *rhs; }
	bool			operator <  (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) < *rhs; }
	bool			operator <= (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) <= *rhs; }
	bool			operator >  (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) > *rhs; }
	bool			operator >= (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) >= *rhs; }

	/// |C^擾
	value_ptr		ptr(void) const			{ return static_cast<value_ptr>(this->m_ptr); }
	/// Xgvf폜邽߂̃\bh
	virtual void	erase(void)				{ this->liberate(); }
	/// |C^̐ݒ
	void			set(value_ptr ptr)		{ IRIS_ASSERT(!this->is_link()); this->m_ptr = ptr; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
