//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSingleton.h
 * @brief		VOgx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSingleton_H_
#define INCG_IRIS_FndSingleton_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	VOgx[XNX
 * @tparam	_TN			= Ώی^
 * @tparam	_NUM_INST	= CX^X̌
*/
template<typename _TN, u32 _NUM_INST=1>
class CSingleton : public INonCopyable<>
{
	IRIS_STATIC_ASSERT( _NUM_INST > 0 );

public:
	static const u32	NUM_INST = _NUM_INST;
public:
	typedef _TN			value_type;
	typedef _TN			*value_ptr;
	typedef _TN			&value_ref;
	typedef const _TN	*const_ptr;
	typedef const _TN	&const_ref;
private:
	s32	m_idx;	//!< CX^XCfbNX

public:
	/// CX^X̗L
	static bool			is_valid(s32 idx=0)			{ return (ptr(idx) != nullptr); }
	/// CX^X̎擾
	static value_ref	GetInstance(s32 idx=0)		{ IRIS_ASSERT( ptr(idx) != nullptr ); return *ptr(idx); }
	/// CX^XAhX̎擾
	static value_ptr	GetInstancePtr(s32 idx=0)	{ return ptr(idx); }

protected:
	/// RXgN^
	CSingleton(s32 idx=0)
		: m_idx(idx)
	{
		IRIS_ASSERT( ptr(idx) == nullptr );
		s32w64 ofs = (s32w64)(value_ptr)1 - (s32w64)(CSingleton<value_type>*)(value_ptr)1;
		ptr(idx) = (value_ptr)((s32w64)this + ofs);
	}
	/// fXgN^
	~CSingleton(void)
	{
		ptr(m_idx) = nullptr;
		m_idx = NUM_INST;
	}

private:
	static volatile value_ptr& ptr(s32 idx)
	{
		static value_ptr s_instance[NUM_INST] = { nullptr };
		IRIS_ASSERT( idx < NUM_INST );
		return s_instance[idx];
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
