//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSearch.h
 * @brief		\[g֐Qt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSearch_H_
#define INCG_IRIS_FndSearch_H_

//======================================================================
// include
#include "FndOperator.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
// 񕪒T
template<typename _TN, typename _Func>
int	BinarySearch(s32 num, _TN* elem, const _Func& func);

//======================================================================
// define
#ifdef _IRIS_DEBUGTEST_ENABLE
#  define SDTR_DUMP(txt, fn1, fn2)	printf(txt " : func %d.\n", fn1.count() + fn2.count());
#else
#  define SDTR_DUMP(txt, fn1, fn2)	__noop
#endif

//======================================================================
// function
/**
 * @brief	񕪒T
 * @tparam _TN		= Tz^
 * @tparam _Less	= rIuWFNg
 * @tparam _Equal	= rIuWFNg
 * @tparam _ARG_TN	= Tz̈p̌^
 * @param [in]	num		= zTCY
 * @param [in]	elem	= z
 * @param [in]	func	= rIuWFNg
 * @param [in]	target	= l
*/
template<typename _TN, typename _Less, typename _Equal, typedef _ARG_TN = const _TN&>
s32	BinarySearch(s32 num, _TN* elem, const _Less& less, const _Equal& equal, _ARG_TN target)
{
	IRIS_ASSERT(elem != nullptr);
	s32 s = 0;
	s32 e = num-1;
	s32 n = s + ((num-s)>>1);
	while(s<=e)
	{
		const _TN temp = *(elem + n);
		if( equal(temp, target) )
		{
			return n;
		}
		if( less(temp, target) )	s = n+1;
		else						e = n-1;
		n = s + ((e-s+1)>>1);
	}
;	return -1;
}

}	// end of namespace fnd
}	// end of namespace iris

// undef
#undef SDTR_DUMP

#endif
